/*
 * Decompiled with CFR 0.152.
 */
package com.github.kancyframework.timewatcher.span;

import com.github.kancyframework.timewatcher.WatchContext;
import com.github.kancyframework.timewatcher.span.SimpleTimeSpan;
import com.github.kancyframework.timewatcher.span.TimeSpan;
import com.github.kancyframework.timewatcher.span.TimeSpanImage;
import com.github.kancyframework.timewatcher.span.TimeSpanPanel;
import com.github.kancyframework.timewatcher.span.TimeSpaner;
import com.github.kancyframework.timewatcher.span.WatchContextTimeSpan;
import com.github.kancyframework.timewatcher.utils.ImageUtils;
import com.github.kancyframework.timewatcher.utils.PopupMenuUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;

public class TimeSpanFrame
extends JFrame
implements ActionListener {
    private List<TimeSpan> timeSpans;

    public TimeSpanFrame(List<TimeSpan> timeSpans) {
        this.timeSpans = timeSpans;
    }

    public static void show(WatchContext context) {
        TimeSpanFrame frame = new TimeSpanFrame(TimeSpaner.getTimeSpans(context));
        frame.init();
    }

    public static void show(List<TimeSpan> timeSpans) {
        TimeSpanFrame frame = new TimeSpanFrame(timeSpans);
        frame.init();
    }

    public void init() {
        this.setSize(1720, 850);
        this.setDefaultCloseOperation(3);
        this.setContentPane(this.initScrollTimeSpanPanel(this.timeSpans));
        this.setTitle("TimeWatcher \u8017\u65f6\u5206\u6790");
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    private JComponent initScrollTimeSpanPanel(List<TimeSpan> timeSpans) {
        TimeSpanPanel spanJPanel = new TimeSpanPanel(timeSpans);
        int width = this.getWidth();
        int height = timeSpans.size() * 31 + 10;
        spanJPanel.setPreferredSize(new Dimension(width, height));
        JScrollPane jScrollPane = new JScrollPane(spanJPanel);
        this.initPopupMenu(jScrollPane);
        return jScrollPane;
    }

    private void initPopupMenu(Component component) {
        JPopupMenu popupMenu = new JPopupMenu();
        PopupMenuUtils.addMenuItem(popupMenu, "\u590d\u5236\u8017\u65f6\u62a5\u544a", this, "copyReport", KeyStroke.getKeyStroke("ctrl C"));
        PopupMenuUtils.addMenuItem(popupMenu, "\u8017\u65f6\u62a5\u544a\u53e6\u5b58\u4e3a", this, "saveAs", KeyStroke.getKeyStroke("ctrl S"));
        PopupMenuUtils.addPopupMenu(component, popupMenu);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        TimeSpanImage timeSpanImage;
        byte[] imageBytes;
        String actionCommand = e.getActionCommand();
        if (Objects.equals(actionCommand, "saveAs")) {
            FileDialog fileDialog = new FileDialog(this);
            fileDialog.setFile(this.getDefaultFileName(this.timeSpans));
            fileDialog.setMode(1);
            fileDialog.setTitle("\u8017\u65f6\u62a5\u544a\u53e6\u5b58\u4e3a");
            fileDialog.setLocationRelativeTo(this);
            fileDialog.setModal(true);
            fileDialog.setVisible(true);
            String fileName = fileDialog.getFile();
            if (Objects.nonNull(fileName) && !fileName.isEmpty()) {
                String filePath = String.format("%s%s", fileDialog.getDirectory(), fileName);
                TimeSpanImage timeSpanImage2 = new TimeSpanImage(this.timeSpans);
                timeSpanImage2.save(filePath);
                JOptionPane.showMessageDialog(this, "\u4fdd\u5b58\u6210\u529f\uff01");
            }
            fileDialog.dispose();
        }
        if (Objects.equals(actionCommand, "copyReport") && (imageBytes = (timeSpanImage = new TimeSpanImage(this.timeSpans)).getImageBytes()).length > 0) {
            ImageUtils.setClipboardImage(imageBytes);
        }
    }

    private String getDefaultFileName(List<TimeSpan> timeSpans) {
        if (Objects.nonNull(timeSpans) && !timeSpans.isEmpty()) {
            TimeSpan timeSpan = timeSpans.get(0);
            if (timeSpan instanceof SimpleTimeSpan) {
                return ((SimpleTimeSpan)timeSpan).getFileName();
            }
            if (timeSpan instanceof WatchContextTimeSpan) {
                return ((WatchContextTimeSpan)timeSpan).getFileName();
            }
        }
        return "\u8017\u65f6\u5206\u6790\u62a5\u544a.png";
    }
}

