/*
 * Decompiled with CFR 0.152.
 */
package com.github.kancyframework.timewatcher.span;

import com.github.kancyframework.timewatcher.WatchContext;
import com.github.kancyframework.timewatcher.span.TimeSpan;
import com.github.kancyframework.timewatcher.span.TimeSpaner;
import com.github.kancyframework.timewatcher.utils.ImageUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.io.File;
import java.math.BigDecimal;
import java.text.AttributedString;
import java.util.List;

public class TimeSpanImage {
    private static final Color indexLineColor = Color.decode("#8DCDFE");
    private final List<TimeSpan> timeSpans;

    public TimeSpanImage(List<TimeSpan> timeSpans) {
        this.timeSpans = timeSpans;
    }

    public static TimeSpanImage create(WatchContext context) {
        return new TimeSpanImage(TimeSpaner.getTimeSpans(context));
    }

    public static TimeSpanImage create(List<TimeSpan> timeSpans) {
        return new TimeSpanImage(timeSpans);
    }

    public void save(String filePath) {
        this.save(new File(filePath));
    }

    public void save(File file) {
        int width = 1720;
        int height = this.timeSpans.size() * 31 + 10;
        ImageUtils.drawImage(width, height, g -> {
            g.setColor(Color.WHITE);
            g.fillRect(0, 0, width, height);
            this.drawTimeSpanImage((Graphics2D)g);
        }, file.getAbsolutePath());
    }

    public byte[] getImageBytes() {
        int width = 1720;
        int height = this.timeSpans.size() * 31 + 10;
        return ImageUtils.drawImage(width, height, g -> {
            g.setColor(Color.WHITE);
            g.fillRect(0, 0, width, height);
            this.drawTimeSpanImage((Graphics2D)g);
        });
    }

    private void drawTimeSpanImage(Graphics2D g) {
        for (TimeSpan timeSpan : this.timeSpans) {
            AttributedString indexLabelAttributedString = timeSpan.getIndexLabelAttributedString();
            g.drawString(indexLabelAttributedString.getIterator(), 5, timeSpan.getY() + 18);
            g.setColor(timeSpan.getSpanColor());
            g.fillRect(timeSpan.getX(), timeSpan.getY(), timeSpan.getWidth(), timeSpan.getHeight());
            AttributedString spanLabelAttributedString = timeSpan.getSpanLabelAttributedString();
            g.drawString(spanLabelAttributedString.getIterator(), timeSpan.getX() + 5, timeSpan.getY() + 18);
            if (!timeSpan.isFirst()) continue;
            AttributedString rootSpanTimeLabelAttributedString = timeSpan.getRootSpanTimeLabelAttributedString();
            g.drawString(rootSpanTimeLabelAttributedString.getIterator(), timeSpan.getX() + 1600 - 355, timeSpan.getY() + 18);
        }
        BasicStroke dash = new BasicStroke(1.0f, 0, 1, 2.0f, new float[]{10.0f, 5.0f}, 0.0f);
        g.setStroke(dash);
        g.setColor(indexLineColor);
        int height = this.timeSpans.size() * 31 + 10;
        g.drawLine(45, 3, 45, height - 3);
        g.dispose();
    }

    private void drawTimeScale(Graphics g, TimeSpan timeSpan) {
        long totalTime = timeSpan.getTotalTime();
        int num = 20;
        double rate = 1600.0 / (double)totalTime;
        double ms = (double)totalTime * 1.0 / (double)num;
        double spanLen = ms * rate;
        int x = 0;
        int t = 0;
        boolean secFlag = false;
        if (totalTime > (long)(num * 500)) {
            secFlag = true;
        }
        for (int i = 0; i <= num; ++i) {
            t = (int)((double)i * ms);
            x = (int)(spanLen * (double)i + 60.0);
            if (x > 1660) break;
            if (secFlag) {
                String st = new BigDecimal(String.valueOf((double)t / 1000.0)).stripTrailingZeros().toPlainString() + "s";
                g.drawString(st, i == num ? x - 20 : x, 11);
                continue;
            }
            g.drawString(String.valueOf(t), i == num ? x - 20 : x, 11);
        }
    }
}

