/*
 * Decompiled with CFR 0.152.
 */
package com.github.kancyframework.timewatcher.span;

import com.github.kancyframework.timewatcher.span.TimeSpan;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.math.BigDecimal;
import java.text.AttributedString;
import java.util.List;
import javax.swing.JPanel;

public class TimeSpanPanel
extends JPanel {
    private static final Color indexLineColor = Color.decode("#8DCDFE");
    private final List<TimeSpan> timeSpans;

    public TimeSpanPanel(List<TimeSpan> timeSpans) {
        this.timeSpans = timeSpans;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        for (TimeSpan timeSpan : this.timeSpans) {
            AttributedString indexLabelAttributedString = timeSpan.getIndexLabelAttributedString();
            g.drawString(indexLabelAttributedString.getIterator(), 5, timeSpan.getY() + 18);
            g.setColor(timeSpan.getSpanColor());
            g.fillRect(timeSpan.getX(), timeSpan.getY(), timeSpan.getWidth(), timeSpan.getHeight());
            AttributedString spanLabelAttributedString = timeSpan.getSpanLabelAttributedString();
            g.drawString(spanLabelAttributedString.getIterator(), timeSpan.getX() + 5, timeSpan.getY() + 18);
            if (!timeSpan.isFirst()) continue;
            AttributedString rootSpanTimeLabelAttributedString = timeSpan.getRootSpanTimeLabelAttributedString();
            g.drawString(rootSpanTimeLabelAttributedString.getIterator(), timeSpan.getX() + 1600 - 355, timeSpan.getY() + 18);
        }
        BasicStroke dash = new BasicStroke(1.0f, 0, 1, 2.0f, new float[]{10.0f, 5.0f}, 0.0f);
        ((Graphics2D)g).setStroke(dash);
        g.setColor(indexLineColor);
        g.drawLine(45, 3, 45, this.getHeight() - 3);
        g.dispose();
    }

    private void drawTimeScale(Graphics g, TimeSpan timeSpan) {
        long totalTime = timeSpan.getTotalTime();
        int num = 20;
        double rate = 1600.0 / (double)totalTime;
        double ms = (double)totalTime * 1.0 / (double)num;
        double spanLen = ms * rate;
        int x = 0;
        int t = 0;
        boolean secFlag = false;
        if (totalTime > (long)(num * 500)) {
            secFlag = true;
        }
        for (int i = 0; i <= num; ++i) {
            t = (int)((double)i * ms);
            x = (int)(spanLen * (double)i + 60.0);
            if (x > 1660) break;
            if (secFlag) {
                String st = new BigDecimal(String.valueOf((double)t / 1000.0)).setScale(2).stripTrailingZeros().toPlainString() + "s";
                g.drawString(st, i == num ? x - 20 : x, 11);
                continue;
            }
            g.drawString(String.valueOf(t), i == num ? x - 20 : x, 11);
        }
    }
}

