/*
 * Decompiled with CFR 0.152.
 */
package com.github.kancyframework.timewatcher.span;

import com.github.kancyframework.timewatcher.WatchContext;
import com.github.kancyframework.timewatcher.WatchRecord;
import com.github.kancyframework.timewatcher.span.TimeSpan;
import java.awt.Color;
import java.text.SimpleDateFormat;
import java.util.Map;
import java.util.Objects;

public class WatchContextTimeSpan
extends TimeSpan {
    private static Color threadColor = Color.decode("#BDCDFE");
    private final WatchRecord watchRecord;
    private final WatchContext watchContext;

    public WatchContextTimeSpan(int index, WatchRecord watchRecord, WatchContext watchContext) {
        super(index);
        this.watchRecord = watchRecord;
        this.watchContext = watchContext;
        this.init();
    }

    protected void init() {
        long startTs = this.watchContext.getRootWatchRecord().getStartTime().getTime();
        long xtime = this.watchRecord.getStartTime().getTime();
        long total = this.watchContext.getRootWatchRecord().getCostMillis();
        this.x = (int)((xtime - startTs) * 1600L / total + 60L);
        this.y = 31 * this.index + 10;
        this.width = (int)(this.watchRecord.getCostMillis() * 1600L / total);
        this.height = 26;
    }

    @Override
    public long getTotalTime() {
        return this.watchContext.getRootWatchRecord().getCostMillis();
    }

    @Override
    public Color getSpanColor() {
        long stopTime;
        if (this.index < 2) {
            return super.getSpanColor();
        }
        long preStopTime = this.watchContext.getWatchRecords().get(this.index - 2).getStopTime().getTime();
        if (preStopTime < (stopTime = this.watchRecord.getStartTime().getTime()) + 1L) {
            return super.getSpanColor();
        }
        return threadColor;
    }

    private String getThreadName() {
        String threadName = this.watchRecord.getThreadName();
        if (threadName.startsWith("http-nio-") && threadName.contains("-exec-")) {
            String[] strings = threadName.split("-");
            return String.format("%s-exec-%s", strings[0], strings[strings.length - 1]);
        }
        return threadName;
    }

    @Override
    public String getSpanLabel() {
        if (this.isFirst()) {
            return this.getRootSpanLabel();
        }
        String spanLabel = String.format("%sms | %s | %s", this.watchRecord.getCostMillis(), this.getThreadName(), this.getWatchNameLabel());
        if (!this.hasWidth(spanLabel) && !this.hasWidth(spanLabel = String.format("%sms | %s | %s", this.watchRecord.getCostMillis(), this.getThreadName(), this.getWatchName()))) {
            spanLabel = String.format("%sms | %s", this.watchRecord.getCostMillis(), this.getWatchName());
        }
        return spanLabel;
    }

    private String getWatchName() {
        String watchName = this.watchRecord.getWatchName();
        if (Objects.nonNull(watchName)) {
            return watchName;
        }
        return "";
    }

    private boolean hasWidth(String spanLabel) {
        if (this.getWidth() > 500) {
            return true;
        }
        int needWith = spanLabel.length() * 7;
        int hasWith = 1720 - this.getX();
        return hasWith > needWith;
    }

    private String getWatchNameLabel() {
        Map<String, Object> properties = this.watchRecord.getProperties();
        if (Objects.isNull(properties)) {
            return this.getWatchName();
        }
        Object className = properties.get("__className__");
        if (Objects.isNull(className)) {
            return this.getWatchName();
        }
        String classSimpleName = this.getClassSimpleName(className.toString());
        return String.format("%s.%s", classSimpleName, this.watchRecord.getWatchName());
    }

    private String getClassSimpleName(String className) {
        if (Objects.isNull(className) || "null".equalsIgnoreCase(className)) {
            return null;
        }
        if (!className.contains(".")) {
            return className;
        }
        return className.substring(className.lastIndexOf(".") + 1);
    }

    @Override
    public String getRootSpanTimeLabel() {
        if (this.isFirst()) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
            return String.format("%s - %s\uff08%sms\uff09", sdf.format(this.watchContext.getRootWatchRecord().getStartTime()), sdf.format(this.watchContext.getRootWatchRecord().getStopTime()), this.watchContext.getRootWatchRecord().getCostMillis());
        }
        return "";
    }

    private String getRootSpanLabel() {
        Object url = this.watchContext.getRootWatchRecord().getProperties().get("__url__");
        String contextName = this.watchContext.getContextName();
        return String.format("%sms | %s | %s%s%s", this.watchRecord.getCostMillis(), this.getThreadName(), Objects.nonNull(url) && !contextName.contains("url") ? String.format("%s (%s)", contextName, url) : contextName, this.getClassAndMethodLabel(), this.getTraceIdLabel());
    }

    private String getTraceIdLabel() {
        if (Objects.isNull(this.watchContext.getTraceId())) {
            return String.format(" ( id:%s )", this.watchContext.getContextId());
        }
        return String.format(" ( traceId:%s )", this.watchContext.getTraceId());
    }

    private String getClassAndMethodLabel() {
        Map<String, Object> properties = this.watchContext.getRootWatchRecord().getProperties();
        if (Objects.nonNull(properties)) {
            Object className = properties.get("__className__");
            Object methodName = properties.get("__methodName__");
            if (Objects.nonNull(className) && Objects.nonNull(className)) {
                return String.format(" [%s.%s]", className, methodName);
            }
            if (Objects.nonNull(className)) {
                return String.format(" [%s]", className);
            }
            if (Objects.nonNull(methodName)) {
                return String.format(" [%s]", methodName);
            }
        }
        return "";
    }

    public String getFileName() {
        return String.format("\u8017\u65f6\u5206\u6790\u62a5\u544a_%s.png", this.watchContext.getContextId());
    }
}

