/*
 * Decompiled with CFR 0.152.
 */
package com.github.kancyframework.timewatcher.utils;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.util.function.Consumer;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageUtils {
    private static final Logger log = LoggerFactory.getLogger(ImageUtils.class);

    public static void drawImage(int width, int height, Consumer<Graphics2D> consumer, String filePath) {
        BufferedImage targetImg = new BufferedImage(width, height, 1);
        Graphics2D g2d = targetImg.createGraphics();
        consumer.accept(g2d);
        g2d.dispose();
        try (FileOutputStream outputStream = new FileOutputStream(filePath);){
            ImageIO.write((RenderedImage)targetImg, "PNG", outputStream);
        }
        catch (Exception e) {
            log.info("ImageIO.write fail : {} , filePath : {}", (Object)e.getMessage(), (Object)filePath);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] drawImage(int width, int height, Consumer<Graphics2D> consumer) {
        BufferedImage targetImg = new BufferedImage(width, height, 1);
        Graphics2D g2d = targetImg.createGraphics();
        consumer.accept(g2d);
        g2d.dispose();
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            ImageIO.write((RenderedImage)targetImg, "PNG", byteArrayOutputStream);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            return new byte[0];
        }
    }

    public static void setClipboardImage(byte[] imageBytes) {
        ImageUtils.setClipboardImage(new ImageIcon(imageBytes).getImage());
    }

    public static void setClipboardImage(final Image image) {
        Transferable trans = new Transferable(){

            @Override
            public DataFlavor[] getTransferDataFlavors() {
                return new DataFlavor[]{DataFlavor.imageFlavor};
            }

            @Override
            public boolean isDataFlavorSupported(DataFlavor flavor) {
                return DataFlavor.imageFlavor.equals(flavor);
            }

            @Override
            public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
                if (this.isDataFlavorSupported(flavor)) {
                    return image;
                }
                throw new UnsupportedFlavorException(flavor);
            }
        };
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(trans, null);
    }
}

