/*
 * Decompiled with CFR 0.152.
 */
package com.github.kancyframework.validationplus.utils;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdCardUtils {
    private static final Logger logger = LoggerFactory.getLogger(IdCardUtils.class);
    private static final int CHINA_ID_MIN_LENGTH = 15;
    private static final int CHINA_ID_MAX_LENGTH = 18;
    private static final int[] POWER = new int[]{7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2};
    private static final String[] VERIFY_CODE = new String[]{"1", "0", "X", "9", "8", "7", "6", "5", "4", "3", "2"};
    private static final int MIN = 1930;
    private static Map<String, String> cityCodes = new HashMap<String, String>();
    private static final Pattern NUMBER_PATTERN = Pattern.compile("^[0-9]*$");
    private static final Pattern TW_ID_PATTERN = Pattern.compile("^[a-zA-Z][0-9]{9}$");
    private static final Pattern HK_ID_PATTERN = Pattern.compile("^[A-Z]{1,2}[0-9]{6}\\(?[0-9A]\\)?$");
    private static final Pattern AM_ID_PATTERN = Pattern.compile("^[1|5|7][0-9]{6}\\(?[0-9A-Z]\\)?$");

    public static boolean validateCard(String idCard) {
        String card = idCard.trim();
        if (IdCardUtils.validateIdCard18(card)) {
            return true;
        }
        if (IdCardUtils.validateIdCard15(card)) {
            return true;
        }
        return IdCardUtils.validateIdCard10(card);
    }

    private static boolean validateIdCard18(String idCard) {
        boolean bTrue = false;
        if (idCard.length() == 18) {
            int[] iCard;
            int iSum17;
            String val;
            char[] cArr;
            String code17 = idCard.substring(0, 17);
            String code18 = idCard.substring(17, 18);
            if (IdCardUtils.isNumberString(code17) && (cArr = code17.toCharArray()) != null && (val = IdCardUtils.getCheckCode18(iSum17 = IdCardUtils.getPowerSum(iCard = IdCardUtils.charToInt(cArr)))).length() > 0 && val.equalsIgnoreCase(code18)) {
                bTrue = true;
            }
        }
        return bTrue;
    }

    private static boolean validateIdCard15(String idCard) {
        if (idCard.length() != 15 || !IdCardUtils.isNumberString(idCard)) {
            return false;
        }
        String proCode = idCard.substring(0, 2);
        if (Objects.isNull(cityCodes.get(proCode))) {
            return false;
        }
        String birthCode = idCard.substring(6, 12);
        Date birthDate = null;
        try {
            birthDate = new SimpleDateFormat("yy").parse(birthCode.substring(0, 2));
            Calendar cal = Calendar.getInstance();
            cal.setTime(birthDate);
            if (!IdCardUtils.validDate(cal.get(1), Integer.parseInt(birthCode.substring(2, 4)), Integer.parseInt(birthCode.substring(4, 6)))) {
                return false;
            }
        }
        catch (Exception e) {
            logger.warn(e.getMessage());
            return false;
        }
        return true;
    }

    private static boolean validateIdCard10(String idCard) {
        if (idCard.length() < 8 || idCard.length() > 10) {
            return false;
        }
        if (TW_ID_PATTERN.matcher(idCard).matches()) {
            return true;
        }
        if (HK_ID_PATTERN.matcher(idCard).matches()) {
            return true;
        }
        return AM_ID_PATTERN.matcher(idCard).matches();
    }

    private static int[] charToInt(char[] ca) {
        int len = ca.length;
        int[] iArr = new int[len];
        try {
            for (int i = 0; i < len; ++i) {
                iArr[i] = Integer.parseInt(String.valueOf(ca[i]));
            }
        }
        catch (NumberFormatException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return iArr;
    }

    private static int getPowerSum(int[] iArr) {
        int iSum = 0;
        if (POWER.length == iArr.length) {
            for (int i = 0; i < iArr.length; ++i) {
                for (int j = 0; j < POWER.length; ++j) {
                    if (i != j) continue;
                    iSum += iArr[i] * POWER[j];
                }
            }
        }
        return iSum;
    }

    private static String getCheckCode18(int iSum) {
        return VERIFY_CODE[iSum % VERIFY_CODE.length];
    }

    private static boolean isNumberString(String val) {
        return Objects.nonNull(val) && NUMBER_PATTERN.matcher(val).matches();
    }

    private static boolean validDate(int iYear, int iMonth, int iDate) {
        int datePerMonth;
        Calendar cal = Calendar.getInstance();
        int year = cal.get(1);
        if (iYear < 1930 || iYear >= year) {
            return false;
        }
        if (iMonth < 1 || iMonth > 12) {
            return false;
        }
        switch (iMonth) {
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                datePerMonth = 30;
                break;
            }
            case 2: {
                datePerMonth = iYear % 4 == 0 && iYear % 100 != 0 || iYear % 400 == 0 ? 29 : 28;
                break;
            }
            default: {
                datePerMonth = 31;
            }
        }
        return iDate >= 1 && iDate <= datePerMonth;
    }

    static {
        cityCodes.put("11", "\u5317\u4eac");
        cityCodes.put("12", "\u5929\u6d25");
        cityCodes.put("13", "\u6cb3\u5317");
        cityCodes.put("14", "\u5c71\u897f");
        cityCodes.put("15", "\u5185\u8499\u53e4");
        cityCodes.put("21", "\u8fbd\u5b81");
        cityCodes.put("22", "\u5409\u6797");
        cityCodes.put("23", "\u9ed1\u9f99\u6c5f");
        cityCodes.put("31", "\u4e0a\u6d77");
        cityCodes.put("32", "\u6c5f\u82cf");
        cityCodes.put("33", "\u6d59\u6c5f");
        cityCodes.put("34", "\u5b89\u5fbd");
        cityCodes.put("35", "\u798f\u5efa");
        cityCodes.put("36", "\u6c5f\u897f");
        cityCodes.put("37", "\u5c71\u4e1c");
        cityCodes.put("41", "\u6cb3\u5357");
        cityCodes.put("42", "\u6e56\u5317");
        cityCodes.put("43", "\u6e56\u5357");
        cityCodes.put("44", "\u5e7f\u4e1c");
        cityCodes.put("45", "\u5e7f\u897f");
        cityCodes.put("46", "\u6d77\u5357");
        cityCodes.put("50", "\u91cd\u5e86");
        cityCodes.put("51", "\u56db\u5ddd");
        cityCodes.put("52", "\u8d35\u5dde");
        cityCodes.put("53", "\u4e91\u5357");
        cityCodes.put("54", "\u897f\u85cf");
        cityCodes.put("61", "\u9655\u897f");
        cityCodes.put("62", "\u7518\u8083");
        cityCodes.put("63", "\u9752\u6d77");
        cityCodes.put("64", "\u5b81\u590f");
        cityCodes.put("65", "\u65b0\u7586");
        cityCodes.put("71", "\u53f0\u6e7e");
        cityCodes.put("81", "\u9999\u6e2f");
        cityCodes.put("82", "\u6fb3\u95e8");
        cityCodes.put("91", "\u56fd\u5916");
    }
}

