/*
 * Decompiled with CFR 0.152.
 */
package com.github.kancyframework.validationplus.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import org.hibernate.validator.HibernateValidator;
import org.hibernate.validator.HibernateValidatorConfiguration;

public class ValidationUtils {
    private static Validator validator = ((HibernateValidatorConfiguration)((HibernateValidatorConfiguration)Validation.byProvider(HibernateValidator.class).configure()).failFast(false)).buildValidatorFactory().getValidator();
    private static Validator failFastValidator = ((HibernateValidatorConfiguration)((HibernateValidatorConfiguration)Validation.byProvider(HibernateValidator.class).configure()).failFast(true)).buildValidatorFactory().getValidator();

    public static <T> ValidResult validateBean(T bean, Class<?> ... groups) {
        return ValidationUtils.validateBean(bean, true, groups);
    }

    public static <T> ValidResult validateBean(T bean, boolean failFast, Class<?> ... groups) {
        ValidResult result = new ValidResult();
        Set violationSet = failFast ? failFastValidator.validate(bean, (Class[])groups) : validator.validate(bean, (Class[])groups);
        boolean hasError = violationSet != null && violationSet.size() > 0;
        result.setHasErrors(hasError);
        if (hasError) {
            for (ConstraintViolation violation : violationSet) {
                result.addError(violation.getPropertyPath().toString(), violation.getMessage());
            }
        }
        return result;
    }

    public static <T> ValidResult validateProperty(T obj, String propertyName) {
        return ValidationUtils.validateProperty(obj, propertyName, true);
    }

    public static <T> ValidResult validateProperty(T obj, String propertyName, boolean failFast) {
        ValidResult result = new ValidResult();
        Set violationSet = failFast ? failFastValidator.validateProperty(obj, propertyName, new Class[0]) : validator.validateProperty(obj, propertyName, new Class[0]);
        boolean hasError = violationSet != null && violationSet.size() > 0;
        result.setHasErrors(hasError);
        if (hasError) {
            for (ConstraintViolation violation : violationSet) {
                result.addError(propertyName, violation.getMessage());
            }
        }
        return result;
    }

    public static class ErrorMessage {
        private String propertyPath;
        private String message;

        public ErrorMessage() {
        }

        public ErrorMessage(String propertyPath, String message) {
            this.propertyPath = propertyPath;
            this.message = message;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.message);
            if (this.propertyPath != null && this.propertyPath.trim().length() > 0 && !this.message.contains(this.propertyPath)) {
                sb.append("(").append(this.propertyPath).append(")");
            }
            return sb.toString();
        }

        public String getPropertyPath() {
            return this.propertyPath;
        }

        public String getMessage() {
            return this.message;
        }
    }

    public static class ValidResult {
        private boolean hasErrors;
        private List<ErrorMessage> errors = new ArrayList<ErrorMessage>();

        public boolean hasErrors() {
            return this.hasErrors;
        }

        public void setHasErrors(boolean hasErrors) {
            this.hasErrors = hasErrors;
        }

        public List<ErrorMessage> getAllErrors() {
            return this.errors;
        }

        public String getErrors() {
            StringBuilder sb = new StringBuilder();
            for (ErrorMessage error : this.errors) {
                if (error.getMessage().contains(String.format("[%s]", error.getPropertyPath()))) {
                    sb.append(error.getMessage()).append(";");
                    continue;
                }
                sb.append(error.getPropertyPath()).append(":").append(error.getMessage()).append(";");
            }
            return sb.toString();
        }

        public void addError(String propertyName, String message) {
            this.errors.add(new ErrorMessage(propertyName, message));
        }
    }
}

