/*
 * Decompiled with CFR 0.152.
 */
package com.github.kancyframework.validationplus.validator;

import com.github.kancyframework.validationplus.validator.CheckEmptyConstraintValidator;
import java.math.BigDecimal;
import java.util.regex.Pattern;
import javax.validation.constraints.Amount;

public class AmountConstraintValidator
extends CheckEmptyConstraintValidator<Amount, Object> {
    @Override
    protected boolean check(Object value) {
        if (!this.isEmpty(((Amount)this.annotation).regexp()) && !Pattern.compile(((Amount)this.annotation).regexp()).matcher(String.valueOf(value)).find()) {
            return false;
        }
        if (value instanceof Number) {
            return this.doValidByNumber(value);
        }
        if (value instanceof CharSequence) {
            return this.doValidByCharSequence((CharSequence)value);
        }
        return true;
    }

    @Override
    protected boolean requestEmptyResult() {
        return !((Amount)this.annotation).required();
    }

    private boolean doValidByCharSequence(CharSequence value) {
        BigDecimal bigNum = this.getBigDecimalValue(value);
        if (bigNum == null) {
            return false;
        }
        return this.doValidByBigDecimal(bigNum);
    }

    private boolean doValidByNumber(Object value) {
        Number num = (Number)Number.class.cast(value);
        BigDecimal bigNum = num instanceof BigDecimal ? (BigDecimal)num : new BigDecimal(num.toString()).stripTrailingZeros();
        return this.doValidByBigDecimal(bigNum);
    }

    private boolean doValidByBigDecimal(BigDecimal bigNum) {
        boolean validResult = false;
        if (((Amount)this.annotation).integer() > 0) {
            int integerPartLength = bigNum.precision() - bigNum.scale();
            boolean bl = validResult = ((Amount)this.annotation).integer() >= integerPartLength;
            if (!validResult) {
                return false;
            }
        }
        if (((Amount)this.annotation).fraction() > 0) {
            int fractionPartLength = bigNum.scale() < 0 ? 0 : bigNum.scale();
            boolean bl = validResult = ((Amount)this.annotation).fraction() >= fractionPartLength;
            if (!validResult) {
                return false;
            }
        }
        if (bigNum.doubleValue() > ((Amount)this.annotation).max()) {
            return false;
        }
        if (bigNum.doubleValue() < ((Amount)this.annotation).min()) {
            return false;
        }
        return ((Amount)this.annotation).canZero() || bigNum.doubleValue() != 0.0;
    }

    private BigDecimal getBigDecimalValue(CharSequence charSequence) {
        try {
            BigDecimal bd = new BigDecimal(charSequence.toString());
            return bd;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }
}

