/*
 * Decompiled with CFR 0.152.
 */
package com.github.kancyframework.validationplus.validator;

import com.github.kancyframework.validationplus.validator.CheckEmptyConstraintValidator;
import javax.validation.constraints.DataId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataIdConstraintValidator
extends CheckEmptyConstraintValidator<DataId, Object> {
    private static Logger log = LoggerFactory.getLogger(DataIdConstraintValidator.class);

    @Override
    protected boolean check(Object value) {
        Long longValue = null;
        try {
            longValue = value instanceof Long ? (Long)value : Long.valueOf(Long.parseLong(String.valueOf(value)));
        }
        catch (Exception e) {
            log.error("DataId check value is not number.");
            return false;
        }
        return longValue >= ((DataId)this.annotation).min() && longValue <= ((DataId)this.annotation).max();
    }

    @Override
    protected boolean requestEmptyResult() {
        return !((DataId)this.annotation).required();
    }
}

