/*
 * Decompiled with CFR 0.152.
 */
package com.github.kancyframework.validationplus.validator;

import com.github.kancyframework.validationplus.validator.CheckEmptyConstraintValidator;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.validation.ValidationException;
import javax.validation.constraints.EnumCheck;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnumCheckConstraintValidator
extends CheckEmptyConstraintValidator<EnumCheck, Object> {
    private static Logger log = LoggerFactory.getLogger(EnumCheckConstraintValidator.class);
    private static Map<String, Boolean> enumCodeExistCache = new HashMap<String, Boolean>(64);
    private static Map<String, Method> enumMethodCache = new HashMap<String, Method>();

    @Override
    protected boolean check(Object value) {
        if (this.getEnumClass() != Empty.class) {
            return this.doValidByEnumClass(value);
        }
        if (((EnumCheck)this.annotation).enumCode().length > 0 || ((EnumCheck)this.annotation).enumCodeString().length() > 0) {
            return this.doValidByEnumCode(value);
        }
        return true;
    }

    @Override
    protected boolean requestEmptyResult() {
        return !((EnumCheck)this.annotation).required();
    }

    private boolean doValidByEnumCode(Object value) {
        List<String> enumCodes = Arrays.asList(((EnumCheck)this.annotation).enumCode());
        if (enumCodes.isEmpty()) {
            enumCodes = ((EnumCheck)this.annotation).enumCodeString().contains(",") ? Arrays.asList(((EnumCheck)this.annotation).enumCodeString().split(",")) : (((EnumCheck)this.annotation).enumCodeString().contains("|") ? Arrays.asList(((EnumCheck)this.annotation).enumCodeString().split("[|]")) : Collections.singletonList(((EnumCheck)this.annotation).enumCodeString()));
        }
        boolean isValid = enumCodes.contains(String.valueOf(value));
        return ((EnumCheck)this.annotation).reverse() ? !isValid : isValid;
    }

    private boolean doValidByEnumClass(Object value) {
        Enum<?>[] enumConstants;
        if (!this.isEmpty(((EnumCheck)this.annotation).enumMethod())) {
            return this.doValidByEnumMethod(value);
        }
        if (!this.isEmpty(((EnumCheck)this.annotation).enumField())) {
            Class<? extends Enum<?>> enumClass = this.getEnumClass();
            boolean isValid = this.existEnumCode(enumClass, String.valueOf(value), ((EnumCheck)this.annotation).enumField());
            return ((EnumCheck)this.annotation).reverse() ? !isValid : isValid;
        }
        Class<Enum<?>> enumClass = this.getEnumClass();
        for (Enum<?> enumConstant : enumConstants = enumClass.getEnumConstants()) {
            if (!Objects.equals(enumConstant.name(), value)) continue;
            return !((EnumCheck)this.annotation).reverse();
        }
        return ((EnumCheck)this.annotation).reverse();
    }

    private Class<? extends Enum<?>> getEnumClass() {
        return ((EnumCheck)this.annotation).value() == Empty.class ? ((EnumCheck)this.annotation).enumClass() : ((EnumCheck)this.annotation).value();
    }

    private boolean doValidByEnumMethod(Object value) {
        Class<? extends Enum<?>> enumClass = this.getEnumClass();
        boolean isValid = false;
        try {
            Method method = this.getEnumMethod();
            Class<?> parameterType = method.getParameterTypes()[0];
            isValid = (Boolean)method.invoke(enumClass, this.castObjectValue(value, parameterType));
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("EnumCheck enumClass not found " + ((EnumCheck)this.annotation).enumMethod() + " method.");
        }
        catch (Exception e) {
            throw new ValidationException((Throwable)e);
        }
        return ((EnumCheck)this.annotation).reverse() ? !isValid : isValid;
    }

    private Method getEnumMethod() throws NoSuchMethodException {
        String cacheKey = String.format("%s-%s", this.getEnumClass().getName(), ((EnumCheck)this.annotation).enumMethod());
        Method method = enumMethodCache.get(((EnumCheck)this.annotation).enumMethod());
        if (method == null) {
            Method[] declaredMethods;
            for (Method declaredMethod : declaredMethods = this.getEnumClass().getDeclaredMethods()) {
                if (!((EnumCheck)this.annotation).enumMethod().equals(declaredMethod.getName()) || declaredMethod.getParameterCount() != 1) continue;
                method = declaredMethod;
                method.setAccessible(true);
                enumMethodCache.putIfAbsent(cacheKey, method);
                break;
            }
        }
        if (method == null) {
            throw new NoSuchMethodException();
        }
        return method;
    }

    private boolean existEnumCode(Class<?> clazz, String value, String key) {
        String cacheKey = String.format("%s-%s-%s", clazz.getName(), key, value);
        if (!enumCodeExistCache.containsKey(cacheKey)) {
            try {
                for (Object result : clazz.getEnumConstants()) {
                    Field codeField = result.getClass().getDeclaredField(key);
                    codeField.setAccessible(true);
                    if (!value.equals(String.valueOf(codeField.get(result)))) continue;
                    enumCodeExistCache.putIfAbsent(cacheKey, true);
                    break;
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return enumCodeExistCache.containsKey(cacheKey);
    }

    private Object castObjectValue(Object value, Class<?> type) {
        if (type.isInstance(value)) {
            return type.cast(value);
        }
        if (type == String.class) {
            return String.valueOf(value).trim();
        }
        if (type == Integer.class || type == Integer.TYPE) {
            return Integer.valueOf(String.valueOf(value).trim());
        }
        if (type == Long.class || type == Long.TYPE) {
            return Long.valueOf(String.valueOf(value).trim());
        }
        if (type == Double.class || type == Double.TYPE) {
            return Double.valueOf(String.valueOf(value).trim());
        }
        if (type == Float.class || type == Float.TYPE) {
            return Float.valueOf(String.valueOf(value).trim());
        }
        return value;
    }

    public static enum Empty {

    }
}

