/*
 * Decompiled with CFR 0.152.
 */
package com.github.kancyframework.validationplus.validator;

import com.github.kancyframework.validationplus.utils.StringUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Objects;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.hibernate.validator.constraintvalidation.HibernateConstraintValidatorContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HibernateConstraintValidator<A extends Annotation, T>
implements ConstraintValidator<A, T> {
    private static Logger logger = LoggerFactory.getLogger(HibernateConstraintValidator.class);
    private static ThreadLocal<Boolean> emptyResultThreadLocal = ThreadLocal.withInitial(() -> Boolean.FALSE);
    private static ThreadLocal<HibernateConstraintValidatorContext> contextThreadLocal = new ThreadLocal();
    protected A annotation;

    public void initialize(A constraintAnnotation) {
        this.annotation = constraintAnnotation;
        this.doInitialize();
    }

    protected void doInitialize() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValid(T value, ConstraintValidatorContext context) {
        boolean isValid = false;
        try {
            HibernateConstraintValidatorContext hibernateContext = (HibernateConstraintValidatorContext)context;
            isValid = this.doValid(value, hibernateContext);
            if (!isValid) {
                String validBasePath = this.getValidBasePath(hibernateContext);
                logger.debug("{} is {} , parameter verification does not pass.", (Object)validBasePath, value);
                hibernateContext.addMessageParameter("value", value);
                hibernateContext.addMessageParameter("fieldValue", value);
                if (this.getEmptyResult()) {
                    context.disableDefaultConstraintViolation();
                    String message = String.format("{%s.empty.message}", this.getAnnotationClassSimpleName());
                    context.buildConstraintViolationWithTemplate(message).addConstraintViolation();
                }
            }
        }
        finally {
            this.removeEmptyResult();
        }
        return isValid;
    }

    protected abstract boolean isValid(T var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doValid(T value, HibernateConstraintValidatorContext context) {
        try {
            contextThreadLocal.set(context);
            boolean bl = this.isValid(value);
            return bl;
        }
        finally {
            contextThreadLocal.remove();
        }
    }

    protected HibernateConstraintValidatorContext getContext() {
        return contextThreadLocal.get();
    }

    protected boolean isEmpty(Object obj) {
        return Objects.isNull(obj) || !StringUtils.hasLength(String.valueOf(obj));
    }

    protected void setEmpty(boolean flag) {
        emptyResultThreadLocal.set(flag);
    }

    protected void removeEmptyResult() {
        emptyResultThreadLocal.remove();
    }

    protected boolean getEmptyResult() {
        return emptyResultThreadLocal.get();
    }

    private String getAnnotationClassSimpleName() {
        Type typeArgument = ((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        return ((Class)typeArgument).getSimpleName();
    }

    protected String getValidBasePath(HibernateConstraintValidatorContext context) {
        String basePath = null;
        try {
            Field basePathField = context.getClass().getDeclaredField("basePath");
            basePathField.setAccessible(true);
            basePath = String.valueOf(basePathField.get(context));
            context.addMessageParameter("fieldName", (Object)basePath);
        }
        catch (Exception e) {
            logger.debug(e.getMessage());
        }
        return basePath;
    }
}

