/*
 * Decompiled with CFR 0.152.
 */
package com.github.kancyframework.validationplus.validator;

import com.github.kancyframework.validationplus.validator.CheckEmptyConstraintValidator;
import java.util.Arrays;
import java.util.Objects;
import javax.validation.constraints.In;

public class InConstraintValidator
extends CheckEmptyConstraintValidator<In, String> {
    @Override
    protected boolean check(String value) {
        String[] items = ((In)this.annotation).value();
        if (items.length == 1) {
            String listStr = items[0];
            if (listStr.contains(",")) {
                return Arrays.asList(listStr.split(",")).contains(value);
            }
            if (listStr.contains("|")) {
                return Arrays.asList(listStr.split("[|]")).contains(value);
            }
            return Objects.equals(value, items);
        }
        if (items.length > 0) {
            return Arrays.asList(items).contains(value);
        }
        return false;
    }

    @Override
    protected boolean requestEmptyResult() {
        return !((In)this.annotation).required();
    }
}

