/*
 * Decompiled with CFR 0.152.
 */
package com.github.kancyframework.validationplus.validator;

import com.github.kancyframework.validationplus.validator.CheckEmptyConstraintValidator;
import java.util.Arrays;
import java.util.Objects;
import javax.validation.constraints.NotIn;

public class NotInConstraintValidator
extends CheckEmptyConstraintValidator<NotIn, String> {
    @Override
    protected boolean check(String value) {
        return !this.in(value);
    }

    private boolean in(String value) {
        String[] items = ((NotIn)this.annotation).value();
        if (items.length == 1) {
            String listStr = items[0];
            if (listStr.contains(",")) {
                return Arrays.asList(listStr.split(",")).contains(value);
            }
            if (listStr.contains("|")) {
                return Arrays.asList(listStr.split("[|]")).contains(value);
            }
            return Objects.equals(value, items);
        }
        if (items.length > 0) {
            return Arrays.asList(items).contains(value);
        }
        return false;
    }

    @Override
    protected boolean requestEmptyResult() {
        return !((NotIn)this.annotation).required();
    }
}

