/*
 * Decompiled with CFR 0.152.
 */
package com.github.kancyframework.validationplus.validator;

import com.github.kancyframework.validationplus.validator.CheckEmptyConstraintValidator;
import java.math.BigDecimal;
import java.util.regex.Pattern;
import javax.validation.constraints.Numeric;

public class NumericConstraintValidator
extends CheckEmptyConstraintValidator<Numeric, Object> {
    @Override
    protected boolean check(Object value) {
        if (!this.isEmpty(((Numeric)this.annotation).regexp()) && !Pattern.compile(((Numeric)this.annotation).regexp()).matcher(String.valueOf(value)).find()) {
            return false;
        }
        if (value instanceof Number) {
            return this.doValidByNumber(value);
        }
        if (value instanceof CharSequence) {
            return this.doValidByCharSequence((CharSequence)value);
        }
        return true;
    }

    @Override
    protected boolean requestEmptyResult() {
        return !((Numeric)this.annotation).required();
    }

    private boolean doValidByCharSequence(CharSequence value) {
        BigDecimal bigNum = this.getBigDecimalValue(value);
        if (bigNum == null) {
            return false;
        }
        return this.doValidByBigDecimal(bigNum);
    }

    private boolean doValidByNumber(Object value) {
        Number num = (Number)Number.class.cast(value);
        BigDecimal bigNum = num instanceof BigDecimal ? (BigDecimal)num : new BigDecimal(num.toString()).stripTrailingZeros();
        return this.doValidByBigDecimal(bigNum);
    }

    private boolean doValidByBigDecimal(BigDecimal bigNum) {
        boolean validResult = false;
        if (((Numeric)this.annotation).integer() >= 0) {
            int integerPartLength = bigNum.precision() - bigNum.scale();
            boolean bl = validResult = ((Numeric)this.annotation).integer() >= integerPartLength;
            if (!validResult) {
                return false;
            }
        }
        if (((Numeric)this.annotation).fraction() >= 0) {
            int fractionPartLength = bigNum.scale() < 0 ? 0 : bigNum.scale();
            boolean bl = validResult = ((Numeric)this.annotation).fraction() >= fractionPartLength;
            if (!validResult) {
                return false;
            }
        }
        if (bigNum.doubleValue() > ((Numeric)this.annotation).max()) {
            return false;
        }
        if (bigNum.doubleValue() < ((Numeric)this.annotation).min()) {
            return false;
        }
        return ((Numeric)this.annotation).canZero() || bigNum.doubleValue() != 0.0;
    }

    private BigDecimal getBigDecimalValue(CharSequence charSequence) {
        try {
            BigDecimal bd = new BigDecimal(charSequence.toString());
            return bd;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }
}

