/*
 * Decompiled with CFR 0.152.
 */
package com.k2.hibernate;

import com.k2.hibernate.Hibernate;
import com.k2.hibernate.HibernateRegistry;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.hibernate.bytecode.spi.ReflectionOptimizer;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.tuple.entity.EntityMetamodel;
import org.hibernate.tuple.entity.PojoEntityInstantiator;
import org.hibernate.tuple.entity.PojoEntityTuplizer;
import org.springframework.beans.DirectFieldAccessor;
import org.springframework.util.ReflectionUtils;

public class HibernateTuplizer
extends PojoEntityTuplizer {
    private List<HibernateRegistry> registries;
    private ReflectionOptimizer reflectionOptimizer;

    public HibernateTuplizer(EntityMetamodel entityMetamodel, PersistentClass mappedEntity) {
        super(entityMetamodel, mappedEntity);
        this.registries = ((Hibernate.HibernateRegistryLocator)entityMetamodel.getSessionFactory().getServiceRegistry().getService(Hibernate.HibernateRegistryLocator.class)).getRegistries();
        DirectFieldAccessor fieldAccessor = new DirectFieldAccessor((Object)this);
        this.reflectionOptimizer = (ReflectionOptimizer)fieldAccessor.getPropertyValue("optimizer");
    }

    protected Instantiator buildInstantiator(EntityMetamodel metamodel, PersistentClass persistentClass) {
        ReflectionOptimizer.InstantiationOptimizer optimizer = null;
        if (this.reflectionOptimizer != null) {
            optimizer = this.reflectionOptimizer.getInstantiationOptimizer();
        }
        return new Instantiator(this, metamodel, persistentClass, optimizer);
    }

    public static class Instantiator
    extends PojoEntityInstantiator {
        private transient HibernateTuplizer tuplizer;
        private PersistentClass persistentClass;

        public Instantiator(HibernateTuplizer theTuplizer, EntityMetamodel entityMetamodel, PersistentClass thePersistentClass, ReflectionOptimizer.InstantiationOptimizer optimizer) {
            super(entityMetamodel, thePersistentClass, optimizer);
            Validate.notNull((Object)((Object)theTuplizer), (String)"The tuplizer cannot be null", (Object[])new Object[0]);
            this.tuplizer = theTuplizer;
            this.persistentClass = thePersistentClass;
        }

        public Object instantiate() {
            for (HibernateRegistry registry : this.tuplizer.registries) {
                Object factory = registry.getFactoryFor(this.persistentClass.getMappedClass());
                if (factory == null) continue;
                Method create = ReflectionUtils.findMethod(factory.getClass(), (String)"create");
                create.setAccessible(true);
                return ReflectionUtils.invokeMethod((Method)create, (Object)factory);
            }
            return super.instantiate();
        }
    }
}

