/*
 * Decompiled with CFR 0.152.
 */
package com.k2.hibernate;

import com.k2.hibernate.Hibernate;
import com.k2.hibernate.HibernateRegistry;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.hibernate.bytecode.spi.ReflectionOptimizer;
import org.hibernate.mapping.Component;
import org.hibernate.tuple.PojoInstantiator;
import org.hibernate.tuple.component.PojoComponentTuplizer;
import org.springframework.beans.DirectFieldAccessor;
import org.springframework.util.ReflectionUtils;

public class HibernateComponentTuplizer
extends PojoComponentTuplizer {
    private List<HibernateRegistry> registries;
    private ReflectionOptimizer reflectionOptimizer;

    public HibernateComponentTuplizer(Component component) {
        super(component);
        this.registries = ((Hibernate.HibernateRegistryLocator)component.getServiceRegistry().getService(Hibernate.HibernateRegistryLocator.class)).getRegistries();
        DirectFieldAccessor fieldAccessor = new DirectFieldAccessor((Object)this);
        this.reflectionOptimizer = (ReflectionOptimizer)fieldAccessor.getPropertyValue("optimizer");
    }

    protected Instantiator buildInstantiator(Component component) {
        ReflectionOptimizer.InstantiationOptimizer optimizer = null;
        if (this.reflectionOptimizer != null) {
            optimizer = this.reflectionOptimizer.getInstantiationOptimizer();
        }
        return new Instantiator(this, component, optimizer);
    }

    public static class Instantiator
    extends PojoInstantiator {
        private transient HibernateComponentTuplizer tuplizer;
        private Component component;
        private Object factoryObject = null;
        private Method factoryMethod = null;

        public Instantiator(HibernateComponentTuplizer theTuplizer, Component theComponent, ReflectionOptimizer.InstantiationOptimizer optimizer) {
            super(theComponent, optimizer);
            Validate.notNull((Object)((Object)theTuplizer), (String)"The tuplizer cannot be null", (Object[])new Object[0]);
            this.tuplizer = theTuplizer;
            this.component = theComponent;
        }

        public Object instantiate() {
            Method create = this.getFactoryMethod();
            if (create != null) {
                return ReflectionUtils.invokeMethod((Method)create, (Object)this.factoryObject);
            }
            return super.instantiate();
        }

        private synchronized Method getFactoryMethod() {
            if (this.factoryMethod == null) {
                for (HibernateRegistry registry : this.tuplizer.registries) {
                    this.factoryObject = registry.getFactoryFor(this.component.getComponentClass());
                    if (this.factoryObject == null) continue;
                    this.factoryMethod = ReflectionUtils.findMethod(this.factoryObject.getClass(), (String)"create");
                    this.factoryMethod.setAccessible(true);
                    break;
                }
            }
            return this.factoryMethod;
        }
    }
}

