/*
 * Decompiled with CFR 0.152.
 */
package com.k2.hibernate;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.EnumSet;
import org.apache.commons.lang3.Validate;
import org.hibernate.boot.Metadata;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.hibernate.tool.schema.TargetType;

public class SchemaGenerator {
    private Metadata metadata;

    public SchemaGenerator(Metadata theMetadata) {
        Validate.notNull((Object)theMetadata, (String)"The metadata cannot be null.", (Object[])new Object[0]);
        this.metadata = theMetadata;
    }

    public void generate() {
        this.generate("target/schema.ddl");
    }

    public void generate(String ddlFile) {
        Validate.notNull((Object)ddlFile, (String)"The file name cannot be null.", (Object[])new Object[0]);
        try {
            Files.deleteIfExists(Paths.get(ddlFile, new String[0]));
        }
        catch (IOException e) {
            throw new RuntimeException("Error deleting " + ddlFile, e);
        }
        SchemaExport schemaExport = new SchemaExport();
        schemaExport.setFormat(true);
        schemaExport.setDelimiter(";");
        schemaExport.setOutputFile(ddlFile);
        schemaExport.execute(EnumSet.of(TargetType.SCRIPT), SchemaExport.Action.CREATE, this.metadata);
    }
}

