/*
 * Decompiled with CFR 0.152.
 */
package com.k2.hibernate;

import com.k2.core.K2Environment;
import com.k2.core.ModuleDefinition;
import com.k2.core.Public;
import com.k2.core.RegistryFactory;
import com.k2.hibernate.HibernateRegistry;
import com.k2.hibernate.HibernateTuplizer;
import com.k2.hibernate.K2DbImplicitNamingStrategy;
import com.k2.hibernate.SchemaGenerator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.apache.tomcat.jdbc.pool.DataSource;
import org.apache.tomcat.jdbc.pool.PoolConfiguration;
import org.apache.tomcat.jdbc.pool.PoolProperties;
import org.hibernate.EntityMode;
import org.hibernate.SessionFactory;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.MetadataBuilder;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.model.naming.ImplicitNamingStrategy;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.MetaAttribute;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Table;
import org.hibernate.service.Service;
import org.hibernate.service.ServiceRegistry;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.PropertySource;
import org.springframework.orm.hibernate5.HibernateTransactionManager;
import org.springframework.stereotype.Component;

@Component(value="hibernate")
@PropertySource(value={"classpath:/com/k2/hibernate/hibernate.properties"})
public class Hibernate
implements RegistryFactory {
    private List<HibernateRegistry> registries = new LinkedList<HibernateRegistry>();

    public HibernateRegistry getRegistry(ModuleDefinition requestor) {
        HibernateRegistry result = new HibernateRegistry(requestor);
        this.registries.add(result);
        return result;
    }

    @Public
    @Bean(name={"transactionManager"})
    public HibernateTransactionManager transactionManager(SessionFactory sessionFactory) {
        HibernateTransactionManager txManager = new HibernateTransactionManager();
        txManager.setSessionFactory(sessionFactory);
        return txManager;
    }

    @Bean
    public Metadata metadata(K2Environment environment, @Value(value="${hibernate.k2.useK2Naming:#{true}}") boolean useK2Naming, @Value(value="${hibernate.k2.usePrefix:#{true}}") boolean usePrefix, DataSource dataSource) {
        StandardServiceRegistry registry = new StandardServiceRegistryBuilder().applySetting("hibernate.connection.datasource", (Object)dataSource).applySetting("hibernate.current_session_context_class", (Object)"org.springframework.orm.hibernate5.SpringSessionContext").applySettings((Map)environment.getProperties("hibernate")).addService(this.getClass(), (Service)new HibernateRegistryLocator(this.registries)).build();
        HashMap prefixes = new HashMap();
        MetadataSources metadataSources = new MetadataSources((ServiceRegistry)registry);
        for (HibernateRegistry hibernateRegistry : this.registries) {
            for (Class<?> entity : hibernateRegistry.getPersistentClasses()) {
                metadataSources.addAnnotatedClass(entity);
                prefixes.put(entity, hibernateRegistry.getRequestorPrefix());
            }
        }
        MetadataBuilder metadataBuilder = metadataSources.getMetadataBuilder().enableNewIdentifierGeneratorSupport(false);
        if (useK2Naming) {
            metadataBuilder.applyImplicitNamingStrategy((ImplicitNamingStrategy)new K2DbImplicitNamingStrategy());
        }
        Metadata metadata = metadataBuilder.build();
        for (PersistentClass pc : metadata.getEntityBindings()) {
            Table table = pc.getTable();
            String prefix = (String)prefixes.get(pc.getMappedClass());
            if (usePrefix) {
                table.setName(prefix + "_" + table.getName());
                for (Map.Entry entry : table.getForeignKeys().entrySet()) {
                    ForeignKey foreignKey = (ForeignKey)entry.getValue();
                    foreignKey.setName(prefix + "_" + foreignKey.getName());
                }
            }
            pc.addTuplizer(EntityMode.POJO, HibernateTuplizer.class.getName());
            MetaAttribute attribute = new MetaAttribute("k2.moduleContext");
            HashMap<String, MetaAttribute> attributes = new HashMap<String, MetaAttribute>();
            attributes.put("k2.moduleContext", attribute);
            pc.setMetaAttributes(attributes);
        }
        return metadata;
    }

    @Public
    @Bean
    public SessionFactory sessionFactory(Metadata metadata) {
        return metadata.getSessionFactoryBuilder().build();
    }

    @ConfigurationProperties(prefix="datasource")
    @Bean
    public PoolProperties poolProperties() {
        PoolProperties properties = new PoolProperties();
        return properties;
    }

    @Bean
    public DataSource dataSource(PoolProperties poolProperties) {
        return new DataSource((PoolConfiguration)poolProperties);
    }

    @Bean
    SchemaGenerator schema(Metadata metadata) {
        return new SchemaGenerator(metadata);
    }

    static class HibernateRegistryLocator
    implements Service {
        private transient List<HibernateRegistry> registries;

        HibernateRegistryLocator(List<HibernateRegistry> theRegistries) {
            Validate.notNull(theRegistries, (String)"The registries cannot be null.", (Object[])new Object[0]);
            this.registries = theRegistries;
        }

        List<HibernateRegistry> getRegistries() {
            return this.registries;
        }
    }
}

