/*
 * Decompiled with CFR 0.152.
 */
package com.k2.hibernate;

import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.naming.ImplicitAnyDiscriminatorColumnNameSource;
import org.hibernate.boot.model.naming.ImplicitAnyKeyColumnNameSource;
import org.hibernate.boot.model.naming.ImplicitBasicColumnNameSource;
import org.hibernate.boot.model.naming.ImplicitCollectionTableNameSource;
import org.hibernate.boot.model.naming.ImplicitDiscriminatorColumnNameSource;
import org.hibernate.boot.model.naming.ImplicitEntityNameSource;
import org.hibernate.boot.model.naming.ImplicitForeignKeyNameSource;
import org.hibernate.boot.model.naming.ImplicitIdentifierColumnNameSource;
import org.hibernate.boot.model.naming.ImplicitIndexColumnNameSource;
import org.hibernate.boot.model.naming.ImplicitIndexNameSource;
import org.hibernate.boot.model.naming.ImplicitJoinColumnNameSource;
import org.hibernate.boot.model.naming.ImplicitJoinTableNameSource;
import org.hibernate.boot.model.naming.ImplicitMapKeyColumnNameSource;
import org.hibernate.boot.model.naming.ImplicitNamingStrategy;
import org.hibernate.boot.model.naming.ImplicitPrimaryKeyJoinColumnNameSource;
import org.hibernate.boot.model.naming.ImplicitTenantIdColumnNameSource;
import org.hibernate.boot.model.naming.ImplicitUniqueKeyNameSource;
import org.springframework.boot.orm.jpa.hibernate.SpringImplicitNamingStrategy;

public class K2DbImplicitNamingStrategy
implements ImplicitNamingStrategy {
    private ImplicitNamingStrategy delegate;

    K2DbImplicitNamingStrategy() {
        this.delegate = new SpringImplicitNamingStrategy();
    }

    K2DbImplicitNamingStrategy(ImplicitNamingStrategy base) {
        this.delegate = base;
    }

    public Identifier determinePrimaryTableName(ImplicitEntityNameSource source) {
        return this.apply(this.delegate.determinePrimaryTableName(source));
    }

    public Identifier determineJoinTableName(ImplicitJoinTableNameSource source) {
        return this.apply(this.delegate.determineJoinTableName(source));
    }

    public Identifier determineCollectionTableName(ImplicitCollectionTableNameSource source) {
        return this.apply(this.delegate.determineCollectionTableName(source));
    }

    public Identifier determineDiscriminatorColumnName(ImplicitDiscriminatorColumnNameSource source) {
        return this.apply(this.delegate.determineDiscriminatorColumnName(source));
    }

    public Identifier determineTenantIdColumnName(ImplicitTenantIdColumnNameSource source) {
        return this.apply(this.delegate.determineTenantIdColumnName(source));
    }

    public Identifier determineIdentifierColumnName(ImplicitIdentifierColumnNameSource source) {
        return this.apply(this.delegate.determineIdentifierColumnName(source));
    }

    public Identifier determineBasicColumnName(ImplicitBasicColumnNameSource source) {
        return this.apply(this.delegate.determineBasicColumnName(source));
    }

    public Identifier determineJoinColumnName(ImplicitJoinColumnNameSource source) {
        return this.apply(this.delegate.determineJoinColumnName(source));
    }

    public Identifier determinePrimaryKeyJoinColumnName(ImplicitPrimaryKeyJoinColumnNameSource source) {
        return this.apply(this.delegate.determinePrimaryKeyJoinColumnName(source));
    }

    public Identifier determineAnyDiscriminatorColumnName(ImplicitAnyDiscriminatorColumnNameSource source) {
        return this.apply(this.delegate.determineAnyDiscriminatorColumnName(source));
    }

    public Identifier determineAnyKeyColumnName(ImplicitAnyKeyColumnNameSource source) {
        return this.apply(this.delegate.determineAnyKeyColumnName(source));
    }

    public Identifier determineMapKeyColumnName(ImplicitMapKeyColumnNameSource source) {
        return this.apply(this.delegate.determineMapKeyColumnName(source));
    }

    public Identifier determineListIndexColumnName(ImplicitIndexColumnNameSource source) {
        return this.apply(this.delegate.determineListIndexColumnName(source));
    }

    public Identifier determineForeignKeyName(ImplicitForeignKeyNameSource source) {
        StringBuilder fkName = new StringBuilder();
        fkName.append("fk_");
        fkName.append(source.getTableName().getText());
        for (Identifier columnName : this.sort(source.getColumnNames())) {
            fkName.append("_").append(columnName.getText());
        }
        fkName.append("_").append(source.getReferencedTableName().getText());
        return this.apply(source.getBuildingContext().getObjectNameNormalizer().normalizeIdentifierQuoting(Identifier.toIdentifier((String)fkName.toString())));
    }

    public Identifier determineUniqueKeyName(ImplicitUniqueKeyNameSource source) {
        StringBuilder fkName = new StringBuilder();
        fkName.append("uk");
        for (Identifier columnName : this.sort(source.getColumnNames())) {
            fkName.append("_").append(columnName.getText());
        }
        return this.apply(source.getBuildingContext().getObjectNameNormalizer().normalizeIdentifierQuoting(Identifier.toIdentifier((String)fkName.toString())));
    }

    public Identifier determineIndexName(ImplicitIndexNameSource source) {
        StringBuilder fkName = new StringBuilder();
        fkName.append("idx");
        for (Identifier columnName : this.sort(source.getColumnNames())) {
            fkName.append("_").append(columnName.getText());
        }
        return this.apply(source.getBuildingContext().getObjectNameNormalizer().normalizeIdentifierQuoting(Identifier.toIdentifier((String)fkName.toString())));
    }

    private Identifier[] sort(List<Identifier> identifiers) {
        Identifier[] result = identifiers.toArray(new Identifier[identifiers.size()]);
        Arrays.sort(result, new Comparator<Identifier>(){

            @Override
            public int compare(Identifier o1, Identifier o2) {
                return o1.getCanonicalName().compareTo(o2.getCanonicalName());
            }
        });
        return result;
    }

    private Identifier apply(Identifier name) {
        LinkedList<String> result = new LinkedList<String>();
        String nameText = name.getText();
        for (String part : StringUtils.splitByCharacterTypeCamelCase((String)nameText)) {
            if ((part = part.replace("_", "")) == null || part.trim().isEmpty()) continue;
            result.add(part.toLowerCase(Locale.ROOT));
        }
        return new Identifier(StringUtils.join(result, (String)"_"), name.isQuoted());
    }
}

