/*
 * Decompiled with CFR 0.152.
 */
package com.k2.hibernate;

import com.k2.core.K2Environment;
import com.k2.core.ModuleDefinition;
import com.k2.core.Public;
import com.k2.core.RegistryFactory;
import com.k2.hibernate.HibernateComponentTuplizer;
import com.k2.hibernate.HibernateEntityTuplizer;
import com.k2.hibernate.HibernateRegistry;
import com.k2.hibernate.K2DbImplicitNamingStrategy;
import com.k2.hibernate.SchemaGenerator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.apache.tomcat.jdbc.pool.DataSource;
import org.apache.tomcat.jdbc.pool.PoolConfiguration;
import org.apache.tomcat.jdbc.pool.PoolProperties;
import org.hibernate.EntityMode;
import org.hibernate.SessionFactory;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.MetadataBuilder;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.model.naming.ImplicitNamingStrategy;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.MetaAttribute;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.UniqueKey;
import org.hibernate.mapping.Value;
import org.hibernate.service.Service;
import org.hibernate.service.ServiceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.PropertySource;
import org.springframework.orm.hibernate5.HibernateTransactionManager;
import org.springframework.stereotype.Component;

@Component(value="hibernate")
@PropertySource(value={"classpath:/com/k2/hibernate/hibernate.properties"})
public class Hibernate
implements RegistryFactory {
    private static Logger log = LoggerFactory.getLogger(Hibernate.class);
    private List<HibernateRegistry> registries = new LinkedList<HibernateRegistry>();

    public HibernateRegistry getRegistry(ModuleDefinition requestor) {
        HibernateRegistry result = new HibernateRegistry(requestor);
        this.registries.add(result);
        return result;
    }

    @Public
    @Bean(name={"transactionManager"})
    public HibernateTransactionManager transactionManager(SessionFactory sessionFactory) {
        HibernateTransactionManager txManager = new HibernateTransactionManager();
        txManager.setSessionFactory(sessionFactory);
        return txManager;
    }

    @Bean
    public Metadata metadata(K2Environment environment, @org.springframework.beans.factory.annotation.Value(value="${hibernate.k2.namingStrategy:#{null}}") String implicitNamingStrategy, @org.springframework.beans.factory.annotation.Value(value="${hibernate.k2.useK2Naming:#{true}}") boolean useK2Naming, @org.springframework.beans.factory.annotation.Value(value="${hibernate.k2.usePrefix:#{true}}") boolean usePrefix, DataSource dataSource) {
        Table table;
        StandardServiceRegistry registry = new StandardServiceRegistryBuilder().applySetting("hibernate.connection.datasource", (Object)dataSource).applySetting("hibernate.current_session_context_class", (Object)"org.springframework.orm.hibernate5.SpringSessionContext").applySettings((Map)environment.getProperties("hibernate")).addService(this.getClass(), (Service)new HibernateRegistryLocator(this.registries)).build();
        HashMap prefixes = new HashMap();
        MetadataSources metadataSources = new MetadataSources((ServiceRegistry)registry);
        for (HibernateRegistry hibernateRegistry : this.registries) {
            for (Class<?> entity : hibernateRegistry.getPersistentClasses()) {
                metadataSources.addAnnotatedClass(entity);
                prefixes.put(entity, hibernateRegistry.getRequestorPrefix());
            }
        }
        MetadataBuilder metadataBuilder = metadataSources.getMetadataBuilder().enableNewIdentifierGeneratorSupport(false);
        if (implicitNamingStrategy != null) {
            ImplicitNamingStrategy namingStrategy = null;
            try {
                Class<ImplicitNamingStrategy> type = Class.forName(implicitNamingStrategy).asSubclass(ImplicitNamingStrategy.class);
                namingStrategy = type.newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new RuntimeException("Error instantiating class " + implicitNamingStrategy, e);
            }
            metadataBuilder.applyImplicitNamingStrategy(namingStrategy);
        } else if (useK2Naming) {
            metadataBuilder.applyImplicitNamingStrategy((ImplicitNamingStrategy)new K2DbImplicitNamingStrategy());
        }
        for (HibernateRegistry hibernateRegistry : this.registries) {
            for (Class<Object> clazz : hibernateRegistry.getConverters()) {
                metadataBuilder.applyAttributeConverter(clazz, true);
            }
        }
        Metadata metadata = metadataBuilder.build();
        HashMap<Table, String> tablePrefixes = new HashMap<Table, String>();
        for (Collection collection : metadata.getCollectionBindings()) {
            table = collection.getCollectionTable();
            String prefix = (String)prefixes.get(collection.getOwner().getMappedClass());
            tablePrefixes.put(table, prefix);
        }
        for (PersistentClass persistentClass : metadata.getEntityBindings()) {
            boolean isSingleTableSubclass;
            table = persistentClass.getTable();
            boolean bl = isSingleTableSubclass = persistentClass.getSuperclass() == null || !persistentClass.getSuperclass().getTable().equals(table);
            if (isSingleTableSubclass) {
                String prefix = (String)prefixes.get(persistentClass.getMappedClass());
                tablePrefixes.put(table, prefix);
            }
            this.configureTuplizers(persistentClass);
            MetaAttribute attribute = new MetaAttribute("k2.moduleContext");
            HashMap<String, MetaAttribute> attributes = new HashMap<String, MetaAttribute>();
            attributes.put("k2.moduleContext", attribute);
            persistentClass.setMetaAttributes(attributes);
        }
        if (usePrefix) {
            for (Map.Entry entry : tablePrefixes.entrySet()) {
                this.prefixDddlElements((Table)entry.getKey(), (String)entry.getValue());
            }
        }
        return metadata;
    }

    private void configureTuplizers(PersistentClass pc) {
        pc.addTuplizer(EntityMode.POJO, HibernateEntityTuplizer.class.getName());
        this.configureComponentTuplizers(pc.getPropertyIterator());
    }

    private void configureComponentTuplizers(Iterator<Property> propertyIterator) {
        while (propertyIterator.hasNext()) {
            Property property = propertyIterator.next();
            Value value = property.getValue();
            if (value instanceof Collection) {
                value = ((Collection)value).getElement();
            }
            if (value instanceof org.hibernate.mapping.Component) {
                org.hibernate.mapping.Component component = (org.hibernate.mapping.Component)value;
                if (component.getTuplizerImplClassName(EntityMode.POJO) != null) continue;
                component.addTuplizer(EntityMode.POJO, HibernateComponentTuplizer.class.getName());
                this.configureComponentTuplizers(component.getPropertyIterator());
                continue;
            }
            log.warn("Type of value is {}, not configuring tuplizer.", value.getClass());
        }
    }

    private void prefixDddlElements(Table table, String prefix) {
        table.setName(prefix + "_" + table.getName());
        for (Map.Entry entry : table.getForeignKeys().entrySet()) {
            ForeignKey foreignKey = (ForeignKey)entry.getValue();
            foreignKey.setName(prefix + "_" + foreignKey.getName());
        }
        Iterator uniqueKeys = table.getUniqueKeyIterator();
        while (uniqueKeys.hasNext()) {
            UniqueKey uniqueKey = (UniqueKey)uniqueKeys.next();
            uniqueKey.setName(prefix + "_" + uniqueKey.getName());
        }
    }

    @Public
    @Bean
    public SessionFactory sessionFactory(Metadata metadata) {
        return metadata.getSessionFactoryBuilder().build();
    }

    @ConfigurationProperties(prefix="datasource")
    @Bean
    public PoolProperties poolProperties() {
        PoolProperties properties = new PoolProperties();
        return properties;
    }

    @Public
    @Bean(name={"dataSource"})
    public DataSource dataSource(PoolProperties poolProperties) {
        return new DataSource((PoolConfiguration)poolProperties);
    }

    @Bean
    SchemaGenerator schema(Metadata metadata) {
        return new SchemaGenerator(metadata);
    }

    static class HibernateRegistryLocator
    implements Service {
        private transient List<HibernateRegistry> registries;

        HibernateRegistryLocator(List<HibernateRegistry> theRegistries) {
            Validate.notNull(theRegistries, (String)"The registries cannot be null.", (Object[])new Object[0]);
            this.registries = theRegistries;
        }

        List<HibernateRegistry> getRegistries() {
            return this.registries;
        }
    }
}

