/*
 * Decompiled with CFR 0.152.
 */
package com.k2.hibernate;

import com.k2.core.ModuleDefinition;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.persistence.AttributeConverter;
import org.apache.commons.lang3.Validate;

public class HibernateRegistry {
    private ModuleDefinition requestor;
    private List<Class<?>> persistentClasses = new LinkedList();
    private Map<Class<?>, Class<?>> factories = new HashMap();
    private List<Class<? extends AttributeConverter<?, ?>>> converters = new LinkedList();

    HibernateRegistry(ModuleDefinition theRequestor) {
        Validate.notNull((Object)theRequestor, (String)"The requestor cannot be null.", (Object[])new Object[0]);
        this.requestor = theRequestor;
    }

    public void registerPersistentClass(Class<?> theClass) {
        Validate.notNull(theClass, (String)"The class cannot be null.", (Object[])new Object[0]);
        this.persistentClasses.add(theClass);
    }

    public void registerPersistentClass(Class<?> theClass, Class<?> factory) {
        this.persistentClasses.add(theClass);
        this.factories.put(theClass, factory);
    }

    public void registerConverter(Class<? extends AttributeConverter<?, ?>> converter) {
        this.converters.add(converter);
    }

    List<Class<?>> getPersistentClasses() {
        return this.persistentClasses;
    }

    List<Class<? extends AttributeConverter<?, ?>>> getConverters() {
        return this.converters;
    }

    Object getFactoryFor(Class<?> persistentClass) {
        Class<?> factoryType = this.factories.get(persistentClass);
        if (factoryType != null) {
            return this.requestor.getBean(factoryType);
        }
        return null;
    }

    String getRequestorPrefix() {
        String prefix = this.requestor.getModuleShortName();
        if (prefix == null) {
            prefix = this.requestor.getModuleName();
        }
        return prefix;
    }
}

