/*
 * Decompiled with CFR 0.152.
 */
package com.k2.hibernate;

import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.naming.ImplicitAnyDiscriminatorColumnNameSource;
import org.hibernate.boot.model.naming.ImplicitAnyKeyColumnNameSource;
import org.hibernate.boot.model.naming.ImplicitBasicColumnNameSource;
import org.hibernate.boot.model.naming.ImplicitCollectionTableNameSource;
import org.hibernate.boot.model.naming.ImplicitDiscriminatorColumnNameSource;
import org.hibernate.boot.model.naming.ImplicitEntityNameSource;
import org.hibernate.boot.model.naming.ImplicitForeignKeyNameSource;
import org.hibernate.boot.model.naming.ImplicitIdentifierColumnNameSource;
import org.hibernate.boot.model.naming.ImplicitIndexColumnNameSource;
import org.hibernate.boot.model.naming.ImplicitIndexNameSource;
import org.hibernate.boot.model.naming.ImplicitJoinColumnNameSource;
import org.hibernate.boot.model.naming.ImplicitJoinTableNameSource;
import org.hibernate.boot.model.naming.ImplicitMapKeyColumnNameSource;
import org.hibernate.boot.model.naming.ImplicitNamingStrategy;
import org.hibernate.boot.model.naming.ImplicitPrimaryKeyJoinColumnNameSource;
import org.hibernate.boot.model.naming.ImplicitTenantIdColumnNameSource;
import org.hibernate.boot.model.naming.ImplicitUniqueKeyNameSource;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.springframework.boot.orm.jpa.hibernate.SpringImplicitNamingStrategy;

public class K2DbImplicitNamingStrategy
implements ImplicitNamingStrategy {
    private static final int MAX_LENGTH = 60;
    private ImplicitNamingStrategy delegate;

    K2DbImplicitNamingStrategy() {
        this.delegate = new SpringImplicitNamingStrategy();
    }

    K2DbImplicitNamingStrategy(ImplicitNamingStrategy base) {
        this.delegate = base;
    }

    public Identifier determinePrimaryTableName(ImplicitEntityNameSource source) {
        return this.apply(this.delegate.determinePrimaryTableName(source));
    }

    public Identifier determineJoinTableName(ImplicitJoinTableNameSource source) {
        return this.apply(this.delegate.determineJoinTableName(source));
    }

    Identifier toIdentifier(String stringForm, MetadataBuildingContext buildingContext) {
        return buildingContext.getMetadataCollector().getDatabase().getJdbcEnvironment().getIdentifierHelper().toIdentifier(stringForm);
    }

    public Identifier determineCollectionTableName(ImplicitCollectionTableNameSource source) {
        return this.apply(this.delegate.determineCollectionTableName(source));
    }

    public Identifier determineDiscriminatorColumnName(ImplicitDiscriminatorColumnNameSource source) {
        return this.apply(this.delegate.determineDiscriminatorColumnName(source));
    }

    public Identifier determineTenantIdColumnName(ImplicitTenantIdColumnNameSource source) {
        return this.apply(this.delegate.determineTenantIdColumnName(source));
    }

    public Identifier determineIdentifierColumnName(ImplicitIdentifierColumnNameSource source) {
        return this.apply(this.delegate.determineIdentifierColumnName(source));
    }

    public Identifier determineBasicColumnName(ImplicitBasicColumnNameSource source) {
        return this.apply(this.delegate.determineBasicColumnName(source));
    }

    public Identifier determineJoinColumnName(ImplicitJoinColumnNameSource source) {
        return this.apply(this.delegate.determineJoinColumnName(source));
    }

    public Identifier determinePrimaryKeyJoinColumnName(ImplicitPrimaryKeyJoinColumnNameSource source) {
        return this.apply(this.delegate.determinePrimaryKeyJoinColumnName(source));
    }

    public Identifier determineAnyDiscriminatorColumnName(ImplicitAnyDiscriminatorColumnNameSource source) {
        return this.apply(this.delegate.determineAnyDiscriminatorColumnName(source));
    }

    public Identifier determineAnyKeyColumnName(ImplicitAnyKeyColumnNameSource source) {
        return this.apply(this.delegate.determineAnyKeyColumnName(source));
    }

    public Identifier determineMapKeyColumnName(ImplicitMapKeyColumnNameSource source) {
        return this.apply(this.delegate.determineMapKeyColumnName(source));
    }

    public Identifier determineListIndexColumnName(ImplicitIndexColumnNameSource source) {
        return this.apply(this.delegate.determineListIndexColumnName(source));
    }

    public Identifier determineForeignKeyName(ImplicitForeignKeyNameSource source) {
        Identifier result = source.getUserProvidedIdentifier();
        if (result == null) {
            StringBuilder fkName = new StringBuilder();
            fkName.append("fk_");
            fkName.append(source.getTableName().getText());
            for (Identifier columnName : this.sort(source.getColumnNames())) {
                fkName.append("_").append(columnName.getText());
            }
            if (fkName.length() <= 60) {
                result = this.apply(source.getBuildingContext().getObjectNameNormalizer().normalizeIdentifierQuoting(this.toIdentifier(fkName.toString(), source.getBuildingContext())));
            } else {
                String name = this.delegate.determineForeignKeyName(source).getText();
                result = source.getBuildingContext().getObjectNameNormalizer().normalizeIdentifierQuoting(this.toIdentifier("fk_" + name, source.getBuildingContext()));
            }
        }
        return result;
    }

    public Identifier determineUniqueKeyName(ImplicitUniqueKeyNameSource source) {
        Identifier result;
        StringBuilder ukName = new StringBuilder();
        ukName.append("uk_");
        ukName.append(source.getTableName());
        for (Identifier columnName : source.getColumnNames()) {
            ukName.append("_").append(columnName.getText());
        }
        if (ukName.length() <= 60) {
            result = this.apply(source.getBuildingContext().getObjectNameNormalizer().normalizeIdentifierQuoting(this.toIdentifier(ukName.toString(), source.getBuildingContext())));
        } else {
            String name = this.delegate.determineUniqueKeyName(source).getText();
            result = source.getBuildingContext().getObjectNameNormalizer().normalizeIdentifierQuoting(this.toIdentifier("uk_" + name, source.getBuildingContext()));
        }
        return result;
    }

    public Identifier determineIndexName(ImplicitIndexNameSource source) {
        StringBuilder fkName = new StringBuilder();
        fkName.append("idx");
        for (Identifier columnName : source.getColumnNames()) {
            fkName.append("_").append(columnName.getText());
        }
        return this.apply(source.getBuildingContext().getObjectNameNormalizer().normalizeIdentifierQuoting(this.toIdentifier(fkName.toString(), source.getBuildingContext())));
    }

    private Identifier[] sort(List<Identifier> identifiers) {
        Identifier[] result = identifiers.toArray(new Identifier[identifiers.size()]);
        Arrays.sort(result, new Comparator<Identifier>(){

            @Override
            public int compare(Identifier o1, Identifier o2) {
                return o1.getCanonicalName().compareTo(o2.getCanonicalName());
            }
        });
        return result;
    }

    protected Identifier apply(Identifier name) {
        LinkedList<String> result = new LinkedList<String>();
        String nameText = name.getText();
        for (String part : StringUtils.splitByCharacterTypeCamelCase((String)nameText)) {
            if ((part = part.replace("_", "")) == null || part.trim().isEmpty()) continue;
            result.add(part.toLowerCase(Locale.ROOT));
        }
        return new Identifier(StringUtils.join(result, (String)"_"), name.isQuoted());
    }
}

