/*
 * Decompiled with CFR 0.152.
 */
package com.k2.hibernate;

import com.k2.hibernate.K2DbImplicitNamingStrategy;
import com.k2.hibernate.Prefix;
import java.lang.reflect.Field;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.Pair;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.naming.ImplicitBasicColumnNameSource;
import org.hibernate.boot.model.naming.ImplicitEntityNameSource;
import org.hibernate.boot.model.naming.ImplicitJoinTableNameSource;
import org.hibernate.boot.model.naming.ImplicitNamingStrategy;
import org.hibernate.boot.model.naming.ImplicitNamingStrategyComponentPathImpl;
import org.hibernate.boot.model.source.spi.AttributePath;
import org.hibernate.boot.spi.MetadataBuildingContext;

public class K2DbImplicitNamingStrategyComponentPath
extends K2DbImplicitNamingStrategy {
    private Class<?> currentClass = null;

    K2DbImplicitNamingStrategyComponentPath() {
        super((ImplicitNamingStrategy)new ImplicitNamingStrategyComponentPathImpl());
    }

    @Override
    public Identifier determinePrimaryTableName(ImplicitEntityNameSource source) {
        try {
            this.currentClass = Class.forName(source.getEntityNaming().getClassName());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Error", e);
        }
        return this.apply(super.determinePrimaryTableName(source));
    }

    @Override
    public Identifier determineJoinTableName(ImplicitJoinTableNameSource source) {
        String name = source.getOwningPhysicalTableName() + "_" + source.getAssociationOwningAttributePath().getProperty();
        return this.apply(this.toIdentifier(name, source.getBuildingContext()));
    }

    @Override
    public Identifier determineBasicColumnName(final ImplicitBasicColumnNameSource source) {
        Pair<Boolean, String> prefix = this.getPrefix(source.getAttributePath());
        String pathAsString = source.getAttributePath().getFullPath();
        if (((Boolean)prefix.getLeft()).booleanValue() || !((String)prefix.getRight()).equals("")) {
            pathAsString = pathAsString.replaceAll("^[^.]*\\.", "");
        }
        if (!((String)prefix.getRight()).equals("")) {
            pathAsString = (String)prefix.getRight() + "." + pathAsString;
        }
        final AttributePath path = AttributePath.parse((String)pathAsString);
        Identifier result = this.apply(super.determineBasicColumnName(new ImplicitBasicColumnNameSource(){

            public MetadataBuildingContext getBuildingContext() {
                return source.getBuildingContext();
            }

            public AttributePath getAttributePath() {
                return path;
            }

            public boolean isCollectionElement() {
                return source.isCollectionElement();
            }
        }));
        return result;
    }

    private Pair<Boolean, String> getPrefix(AttributePath attributePath) {
        AttributePath rootAttribute = attributePath;
        while (!rootAttribute.getParent().isRoot()) {
            rootAttribute = rootAttribute.getParent();
        }
        Field[] fields = this.currentClass.getDeclaredFields();
        Field columnField = null;
        for (Field field : fields) {
            if (!field.getName().equals(rootAttribute.getProperty())) continue;
            columnField = field;
            Prefix prefix = columnField.getAnnotation(Prefix.class);
            if (prefix != null) {
                if (prefix.skip()) {
                    Validate.isTrue((boolean)prefix.value().equals(""), (String)"You cannot specify a prefix value when skipping the prefix", (Object[])new Object[0]);
                }
                return Pair.of((Object)prefix.skip(), (Object)prefix.value());
            }
            return Pair.of((Object)false, (Object)"");
        }
        return Pair.of((Object)false, (Object)"");
    }

    @Override
    protected Identifier apply(Identifier name) {
        String nameText = super.apply(name).getText();
        if (nameText.contains("collection_&&_element_")) {
            nameText = nameText.replace("collection_&&_element_", "");
        }
        return new Identifier(nameText, name.isQuoted());
    }
}

