/*
 * Decompiled with CFR 0.152.
 */
package com.github.khud.kshell.repl;

import com.github.khud.kshell.repl.CodeLine;
import com.github.khud.kshell.repl.CompilationData;
import com.github.khud.kshell.repl.EvalError;
import com.github.khud.kshell.repl.EvalResult;
import com.github.khud.kshell.repl.ReplCompiler;
import com.github.khud.kshell.repl.ReplEvaluator;
import com.github.khud.kshell.repl.ReplState;
import com.github.khud.kshell.repl.Result;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import java.io.File;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.config.CompilerConfiguration;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B1\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bB5\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000eJ\u001a\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001e0\u001c2\u0006\u0010\u001f\u001a\u00020 R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006!"}, d2={"Lcom/github/khud/kshell/repl/Repl;", "", "compilerConfiguration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "baseClasspath", "", "Ljava/io/File;", "baseClassloader", "Ljava/lang/ClassLoader;", "(Lorg/jetbrains/kotlin/config/CompilerConfiguration;Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;Ljava/lang/Iterable;Ljava/lang/ClassLoader;)V", "disposable", "Lcom/intellij/openapi/Disposable;", "(Lcom/intellij/openapi/Disposable;Lorg/jetbrains/kotlin/config/CompilerConfiguration;Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;Ljava/lang/Iterable;Ljava/lang/ClassLoader;)V", "compiler", "Lcom/github/khud/kshell/repl/ReplCompiler;", "getCompiler", "()Lcom/github/khud/kshell/repl/ReplCompiler;", "evaluator", "Lcom/github/khud/kshell/repl/ReplEvaluator;", "getEvaluator", "()Lcom/github/khud/kshell/repl/ReplEvaluator;", "state", "Lcom/github/khud/kshell/repl/ReplState;", "getState", "()Lcom/github/khud/kshell/repl/ReplState;", "eval", "Lcom/github/khud/kshell/repl/Result;", "Lcom/github/khud/kshell/repl/EvalResult;", "Lcom/github/khud/kshell/repl/EvalError;", "code", "", "kshell-repl-api"})
public final class Repl {
    @NotNull
    private final ReplCompiler compiler;
    @NotNull
    private final ReplEvaluator evaluator;
    @NotNull
    private final ReplState state;

    @NotNull
    public final ReplCompiler getCompiler() {
        return this.compiler;
    }

    @NotNull
    public final ReplEvaluator getEvaluator() {
        return this.evaluator;
    }

    @NotNull
    public final ReplState getState() {
        return this.state;
    }

    @NotNull
    public final Result<EvalResult, EvalError> eval(@NotNull String code) {
        Result<EvalResult, EvalError> result;
        Result res;
        Intrinsics.checkParameterIsNotNull((Object)code, (String)"code");
        Result result2 = res = ReplCompiler.compile$default(this.compiler, this.state, new CodeLine(this.state.getLineIndex().getAndIncrement(), code, 0, 4, null), null, 4, null);
        if (result2 instanceof Result.Error) {
            result = new Result.Error(((Result.Error)res).getError());
        } else if (result2 instanceof Result.Success) {
            result = this.evaluator.eval(this.state, (CompilationData)((Result.Success)res).getData(), null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return result;
    }

    public Repl(@NotNull Disposable disposable, @NotNull CompilerConfiguration compilerConfiguration, @NotNull MessageCollector messageCollector, @NotNull Iterable<? extends File> baseClasspath, @Nullable ClassLoader baseClassloader) {
        Intrinsics.checkParameterIsNotNull((Object)disposable, (String)"disposable");
        Intrinsics.checkParameterIsNotNull((Object)compilerConfiguration, (String)"compilerConfiguration");
        Intrinsics.checkParameterIsNotNull((Object)messageCollector, (String)"messageCollector");
        Intrinsics.checkParameterIsNotNull(baseClasspath, (String)"baseClasspath");
        this.compiler = new ReplCompiler(disposable, compilerConfiguration, messageCollector);
        this.evaluator = new ReplEvaluator(baseClasspath, baseClassloader);
        this.state = new ReplState(new ReentrantReadWriteLock());
    }

    public Repl(@NotNull CompilerConfiguration compilerConfiguration, @NotNull MessageCollector messageCollector, @NotNull Iterable<? extends File> baseClasspath, @Nullable ClassLoader baseClassloader) {
        Intrinsics.checkParameterIsNotNull((Object)compilerConfiguration, (String)"compilerConfiguration");
        Intrinsics.checkParameterIsNotNull((Object)messageCollector, (String)"messageCollector");
        Intrinsics.checkParameterIsNotNull(baseClasspath, (String)"baseClasspath");
        Disposable disposable = Disposer.newDisposable();
        Intrinsics.checkExpressionValueIsNotNull((Object)disposable, (String)"Disposer.newDisposable()");
        this(disposable, compilerConfiguration, messageCollector, baseClasspath, baseClassloader);
    }

    public /* synthetic */ Repl(CompilerConfiguration compilerConfiguration, MessageCollector messageCollector, Iterable iterable, ClassLoader classLoader, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            Thread thread = Thread.currentThread();
            Intrinsics.checkExpressionValueIsNotNull((Object)thread, (String)"Thread.currentThread()");
            classLoader = thread.getContextClassLoader();
        }
        this(compilerConfiguration, messageCollector, iterable, classLoader);
    }
}

