/*
 * Decompiled with CFR 0.152.
 */
package com.github.khud.kshell.repl;

import com.github.khud.kshell.repl.EvalError;
import com.github.khud.kshell.repl.EvalResult;
import com.github.khud.kshell.repl.FunctionSnippet;
import com.github.khud.kshell.repl.ReplTestBase;
import com.github.khud.kshell.repl.Result;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.ranges.IntRange;
import org.junit.Assert;
import org.junit.Test;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006H\u0002J\u001c\u0010\t\u001a\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006H\u0002J$\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006H\u0002J\u001c\u0010\r\u001a\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006H\u0002J&\u0010\u000e\u001a\u00020\u00042\b\u0010\u000b\u001a\u0004\u0018\u00010\u000f2\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006H\u0002J\b\u0010\u0010\u001a\u00020\u0004H\u0007J\b\u0010\u0011\u001a\u00020\u0004H\u0007J\b\u0010\u0012\u001a\u00020\u0004H\u0007J\b\u0010\u0013\u001a\u00020\u0004H\u0007J\b\u0010\u0014\u001a\u00020\u0004H\u0007J\b\u0010\u0015\u001a\u00020\u0004H\u0007J\b\u0010\u0016\u001a\u00020\u0004H\u0007J\b\u0010\u0017\u001a\u00020\u0004H\u0007J\b\u0010\u0018\u001a\u00020\u0004H\u0007J\b\u0010\u0019\u001a\u00020\u0004H\u0007J\b\u0010\u001a\u001a\u00020\u0004H\u0007J\b\u0010\u001b\u001a\u00020\u0004H\u0007J\b\u0010\u001c\u001a\u00020\u0004H\u0007J\b\u0010\u001d\u001a\u00020\u0004H\u0007J\b\u0010\u001e\u001a\u00020\u0004H\u0007J\b\u0010\u001f\u001a\u00020\u0004H\u0007J\b\u0010 \u001a\u00020\u0004H\u0007J\b\u0010!\u001a\u00020\u0004H\u0007J\b\u0010\"\u001a\u00020\u0004H\u0007J\b\u0010#\u001a\u00020\u0004H\u0007J\b\u0010$\u001a\u00020\u0004H\u0007\u00a8\u0006%"}, d2={"Lcom/github/khud/kshell/repl/ReplTest;", "Lcom/github/khud/kshell/repl/ReplTestBase;", "()V", "assertError", "", "result", "Lcom/github/khud/kshell/repl/Result;", "Lcom/github/khud/kshell/repl/EvalResult;", "Lcom/github/khud/kshell/repl/EvalError;", "assertSuccess", "assertType", "expected", "", "assertUnit", "assertValue", "", "testClassShadowing", "testCommitRollback", "testCompoundTypesSignature", "testConsistentImportsForDeferredSnippets", "testGenericsShadowing", "testImport", "testInitializers", "testMultipleLinesWithShadowing", "testMultipleShadowing", "testNamespace", "testNullResult", "testNullable", "testObjectShadowing", "testOverloadWithShadowing", "testPermanentSnippets", "testQualifiedImport", "testResult", "testShadowing", "testSimpleValue", "testType", "testWhile", "kshell-repl-api"})
public final class ReplTest
extends ReplTestBase {
    @Test
    public final void testSimpleValue() {
        this.assertValue(2, this.getRepl().eval("1 + 1"));
    }

    @Test
    public final void testMultipleLinesWithShadowing() {
        this.assertValue(11, this.getRepl().eval("val x = 10\nfun f(x: Int)=x\nx + 1"));
        this.assertUnit(this.getRepl().eval("class A() { val x = 10 }"));
        this.assertUnit(this.getRepl().eval("val a = A()"));
        this.assertUnit(this.getRepl().eval("fun f(x: A)=1"));
        this.assertUnit(this.getRepl().eval("fun f(x: A)=2"));
        this.assertValue(2, this.getRepl().eval("f(a)"));
    }

    @Test
    public final void testOverloadWithShadowing() {
        this.assertSuccess(this.getRepl().eval("fun f(x: Int) = 1"));
        this.assertValue(2, this.getRepl().eval("fun f(x: Int) = 2\nfun f(x: Int, y: Int) = x + y\nf(10)"));
    }

    @Test
    public final void testCommitRollback() {
        this.assertError(this.getRepl().eval("fun f(x: Int) = x + 1\nfun f(x: Int, y: Int) = x + y\nval x: Int = TODO()"));
        Assert.assertEquals((Object)0, (Object)this.getRepl().getState().getHistory().size());
    }

    @Test
    public final void testInitializers() {
        this.assertValue(6, this.getRepl().eval("var x = 5\nx = x + 1\nx"));
    }

    @Test
    public final void testShadowing() {
        this.assertSuccess(this.getRepl().eval("val x = 10\nval y = 5"));
        this.assertValue(25, this.getRepl().eval("val x = 20\nx + y"));
        this.assertSuccess(this.getRepl().eval("fun f(x: Int) = x + 1\nfun f(x: Int, y: Int) = x + y"));
        this.assertSuccess(this.getRepl().eval("fun f(x: Int) = 5"));
        this.assertValue(5, this.getRepl().eval("f(10)"));
    }

    @Test
    public final void testGenericsShadowing() {
        this.assertSuccess(this.getRepl().eval("fun <R> f(x: R, y: Int)=x"));
        this.assertSuccess(this.getRepl().eval("fun f(x: Double, y: Int)=x"));
        this.assertSuccess(this.getRepl().eval("fun <K> f(x: K, y: Int)=y"));
        this.assertValue(10, this.getRepl().eval("f(20, 10)"));
        this.assertValue(20.0, this.getRepl().eval("f(20.0, 10)"));
    }

    @Test
    public final void testClassShadowing() {
        this.assertSuccess(this.getRepl().eval("class A { val x = 10 }"));
        this.assertSuccess(this.getRepl().eval("class A { val x = 20 }"));
        this.assertValue(20, this.getRepl().eval("val a = A()\na.x"));
    }

    @Test
    public final void testObjectShadowing() {
        this.assertSuccess(this.getRepl().eval("object A { val x = 10 }"));
        this.assertSuccess(this.getRepl().eval("object A { val x = 20 }"));
        this.assertValue(20, this.getRepl().eval("A.x"));
    }

    @Test
    public final void testNamespace() {
        this.assertValue(11, this.getRepl().eval("val x = 10\nfun x()=1\nx+x()"));
        this.assertValue(11, this.getRepl().eval("object a { val x = 1 }\nfun a() = 10\na() + a.x"));
    }

    @Test
    public final void testResult() {
        this.assertSuccess(this.getRepl().eval("1 + 1"));
        this.assertSuccess(this.getRepl().eval("10"));
        this.assertValue(12, this.getRepl().eval("res1 + res2"));
    }

    @Test
    public final void testMultipleShadowing() {
        int n = 1;
        Iterable $receiver$iv = (Iterable)new IntRange(n, 100);
        Iterator iterator = $receiver$iv.iterator();
        while (iterator.hasNext()) {
            int element$iv;
            int it = element$iv = ((IntIterator)iterator).nextInt();
            this.assertSuccess(this.getRepl().eval("fun f(x: Int) = x + " + it));
        }
        this.assertValue(101, this.getRepl().eval("f(1)"));
    }

    @Test
    public final void testType() {
        this.assertType("kotlin.Int", this.getRepl().eval("1 + 1"));
        this.assertType("kotlin.collections.List<kotlin.Int>", this.getRepl().eval("listOf(1,2,3)"));
    }

    @Test
    public final void testCompoundTypesSignature() {
        this.assertSuccess(this.getRepl().eval("fun <R, T> f(x: List<T>, y: List<Map<R,T>>)=1"));
        Object object = CollectionsKt.last(this.getRepl().getState().getHistory());
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.github.khud.kshell.repl.FunctionSnippet");
        }
        Assert.assertEquals((Object)"List<#1>,List<Map<#0,#1>>", (Object)((FunctionSnippet)object).getParametersTypes());
    }

    @Test
    public final void testImport() {
        this.assertSuccess(this.getRepl().eval("import java.io.File"));
        this.assertSuccess(this.getRepl().eval("fun f(x: File)=x"));
        this.assertSuccess(this.getRepl().eval("fun g(x: File)=x"));
        this.assertSuccess(this.getRepl().eval("import java.io.File"));
        this.assertSuccess(this.getRepl().eval("import java.io.*"));
        this.assertSuccess(this.getRepl().eval("import java.io.*"));
        this.assertSuccess(this.getRepl().eval("fun g1(x: File)=x"));
    }

    @Test
    public final void testConsistentImportsForDeferredSnippets() {
        this.assertSuccess(this.getRepl().eval("import java.io.File\nfun f(x: Int, a: File) = x\nfun f(a: File) = a"));
    }

    @Test
    public final void testPermanentSnippets() {
        this.assertSuccess(this.getRepl().eval("1 + 1"));
        this.assertError(this.getRepl().eval("val res1 = 10"));
    }

    @Test
    public final void testQualifiedImport() {
        this.assertSuccess(this.getRepl().eval("import java.io.File as JFile"));
        this.assertSuccess(this.getRepl().eval("fun f(x: JFile)=x"));
        this.assertSuccess(this.getRepl().eval("fun g(x: JFile)=f(x)"));
        this.assertSuccess(this.getRepl().eval("import java.io.FileInputStream as JFile"));
        this.assertSuccess(this.getRepl().eval("fun f(v: JFile)=v.close()"));
    }

    @Test
    public final void testWhile() {
        this.assertValue(2, this.getRepl().eval("\n           var i = 10\n           var x = 0\n           while (i > 0) {\n                x = 2 * i\n                i --\n           }\n           x\n        "));
    }

    @Test
    public final void testNullable() {
        this.assertSuccess(this.getRepl().eval("fun f(x: Int?) = 10"));
    }

    @Test
    public final void testNullResult() {
        this.assertSuccess(this.getRepl().eval("null"));
    }

    private final void assertValue(Object expected, Result<EvalResult, EvalError> result) {
        Result<EvalResult, EvalError> result2 = result;
        if (result2 instanceof Result.Error) {
            Assert.fail((String)((EvalError)((Result.Error)result).getError()).getMessage());
        } else if (result2 instanceof Result.Success) {
            EvalResult data = (EvalResult)((Result.Success)result).getData();
            EvalResult evalResult = data;
            if (evalResult instanceof EvalResult.UnitResult) {
                Assert.fail((String)"Value result expected");
            } else if (evalResult instanceof EvalResult.ValueResult) {
                Assert.assertEquals((Object)expected, (Object)((EvalResult.ValueResult)data).getValue());
            }
        }
    }

    private final void assertType(String expected, Result<EvalResult, EvalError> result) {
        Result<EvalResult, EvalError> result2 = result;
        if (result2 instanceof Result.Error) {
            Assert.fail((String)((EvalError)((Result.Error)result).getError()).getMessage());
        } else if (result2 instanceof Result.Success) {
            EvalResult data = (EvalResult)((Result.Success)result).getData();
            EvalResult evalResult = data;
            if (evalResult instanceof EvalResult.UnitResult) {
                Assert.fail((String)"Value result expected");
            } else if (evalResult instanceof EvalResult.ValueResult) {
                Assert.assertEquals((Object)expected, (Object)((EvalResult.ValueResult)data).getType());
            }
        }
    }

    private final void assertSuccess(Result<EvalResult, EvalError> result) {
        Result<EvalResult, EvalError> result2 = result;
        if (result2 instanceof Result.Error) {
            Assert.fail((String)((EvalError)((Result.Error)result).getError()).getMessage());
        } else if (result2 instanceof Result.Success) {
            // empty if block
        }
    }

    private final void assertError(Result<EvalResult, EvalError> result) {
        Result<EvalResult, EvalError> result2 = result;
        if (!(result2 instanceof Result.Error) && result2 instanceof Result.Success) {
            Assert.fail((String)"Should be error but success found");
        }
    }

    private final void assertUnit(Result<EvalResult, EvalError> result) {
        EvalResult data;
        EvalResult evalResult;
        Result<EvalResult, EvalError> result2 = result;
        if (result2 instanceof Result.Error) {
            Assert.fail((String)result.toString());
        } else if (result2 instanceof Result.Success && !((evalResult = (data = (EvalResult)((Result.Success)result).getData())) instanceof EvalResult.UnitResult) && evalResult instanceof EvalResult.ValueResult) {
            Assert.fail((String)("Unit result expected, but found " + data));
        }
    }
}

