package org.mapstruct.example.mapper;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Generated;
import org.mapstruct.example.protobuf.Department;
import org.mapstruct.example.protobuf.Permission;
import org.mapstruct.example.protobuf.User;
import org.mapstruct.example.protobuf.UserProtos.DepartmentDTO;
import org.mapstruct.example.protobuf.UserProtos.PermissionDTO;
import org.mapstruct.example.protobuf.UserProtos.UserDTO;
import org.mapstruct.example.protobuf.UserProtos.UserDTO.Builder;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2021-01-29T15:18:34-0800",
    comments = "version: 1.4.1.Final, compiler: javac, environment: Java 1.8.0_275 (AdoptOpenJDK)"
)
public class UserMapperImpl implements UserMapper {

    @Override
    public UserDTO map(User user) {
        if ( user == null ) {
            return null;
        }

        Builder userDTO = UserDTO.newBuilder();

        if ( user.getPermissions() != null ) {
            for ( Permission permission : user.getPermissions() ) {
                userDTO.addPermissions( map( permission ) );
            }
        }
        if ( user.getMainDepartments() != null ) {
            for ( Department mainDepartment : user.getMainDepartments() ) {
                userDTO.addMainDepartments( map( mainDepartment ) );
            }
        }
        if ( user.getDepartments() != null ) {
            for ( Department department : user.getDepartments() ) {
                userDTO.addDepartments( map( department ) );
            }
        }
        if ( user.getId() != null ) {
            userDTO.setId( user.getId() );
        }
        if ( user.getEmail() != null ) {
            userDTO.setEmail( user.getEmail() );
        }

        return userDTO.build();
    }

    @Override
    public User map(UserDTO userDTO) {
        if ( userDTO == null ) {
            return null;
        }

        User user = new User();

        List<Permission> list = permissionDTOListToPermissionList( userDTO.getPermissionsList() );
        if ( list != null ) {
            user.setPermissions( list );
        }
        List<Department> list1 = departmentDTOListToDepartmentList( userDTO.getMainDepartmentsList() );
        if ( list1 != null ) {
            user.setMainDepartments( list1 );
        }
        List<Department> list2 = departmentDTOListToDepartmentList( userDTO.getDepartmentsList() );
        if ( list2 != null ) {
            user.setDepartments( list2 );
        }
        if ( userDTO.getId() != null ) {
            user.setId( userDTO.getId() );
        }
        if ( userDTO.getEmail() != null ) {
            user.setEmail( userDTO.getEmail() );
        }

        return user;
    }

    @Override
    public Permission map(PermissionDTO permissionDTO) {
        if ( permissionDTO == null ) {
            return null;
        }

        Permission permission;

        switch ( permissionDTO ) {
            case UNRECOGNIZED: permission = null;
            break;
            case NONE: permission = Permission.NONE;
            break;
            case USER: permission = Permission.USER;
            break;
            case ADMIN: permission = Permission.ADMIN;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + permissionDTO );
        }

        return permission;
    }

    @Override
    public PermissionDTO map(Permission perm) {
        if ( perm == null ) {
            return null;
        }

        PermissionDTO permissionDTO;

        switch ( perm ) {
            case ADMIN: permissionDTO = PermissionDTO.ADMIN;
            break;
            case USER: permissionDTO = PermissionDTO.USER;
            break;
            case NONE: permissionDTO = PermissionDTO.NONE;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + perm );
        }

        return permissionDTO;
    }

    @Override
    public Department map(DepartmentDTO departmentDTO) {
        if ( departmentDTO == null ) {
            return null;
        }

        Department department = new Department();

        if ( departmentDTO.getName() != null ) {
            department.setName( departmentDTO.getName() );
        }

        return department;
    }

    @Override
    public DepartmentDTO map(Department department) {
        if ( department == null ) {
            return null;
        }

        org.mapstruct.example.protobuf.UserProtos.DepartmentDTO.Builder departmentDTO = DepartmentDTO.newBuilder();

        if ( department.getName() != null ) {
            departmentDTO.setName( department.getName() );
        }

        return departmentDTO.build();
    }

    protected List<Permission> permissionDTOListToPermissionList(List<PermissionDTO> list) {
        if ( list == null ) {
            return null;
        }

        List<Permission> list1 = new ArrayList<Permission>( list.size() );
        for ( PermissionDTO permissionDTO : list ) {
            list1.add( map( permissionDTO ) );
        }

        return list1;
    }

    protected List<Department> departmentDTOListToDepartmentList(List<DepartmentDTO> list) {
        if ( list == null ) {
            return null;
        }

        List<Department> list1 = new ArrayList<Department>( list.size() );
        for ( DepartmentDTO departmentDTO : list ) {
            list1.add( map( departmentDTO ) );
        }

        return list1;
    }
}
