package com.github.krr.schema.generator.protobuf.impl;

import com.github.krr.schema.generator.annotations.SchemaItem;
import org.springframework.util.ReflectionUtils;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

import static com.github.krr.schema.generator.protobuf.impl.ProtobufSchemaGenerator.PACKAGES_TO_SKIP;

public final class FieldsFilterImpl implements ReflectionUtils.FieldFilter {

  private final Class<?> declaringClass;

  public FieldsFilterImpl(Class<?> declaringClass) {
    this.declaringClass = declaringClass;
  }

  @Override
  public boolean matches(Field field) {
    // skip static values, and skipped packages
    Class<?> clazz = field.getType();
    Package classPackage = clazz.getPackage();
    if (classPackage != null && PACKAGES_TO_SKIP.contains(classPackage.getName())) {
      return false;
    }
    int modifiers = field.getModifiers();
    // match only on non-static fields of this class.  The doWithLocalField doesn't
    // support field filter and we want to skip static fields.
    return field.getDeclaringClass().equals(declaringClass) && !Modifier.isStatic(modifiers) &&
           field.getAnnotationsByType(SchemaItem.Transient.class).length == 0;
  }
}

