package com.github.krr.schema.generator.protobuf.mappercodegen;

import com.github.krr.schema.generator.protobuf.model.nodes.attributes.AbstractAttribute;
import lombok.Getter;

@SuppressWarnings("unused")
public abstract class AbstractAttributeCodegenModel extends AbstractCodegenModel {

  @Getter
  protected final AbstractMapperCodegenModel attributeTypeCodegenModel;

  @Getter
  protected final AbstractAttribute attribute;

  /**
   * @param mapperConfig       - the mapper configuration to use for codegen
   * @param factory            - the factory containing all message types that are rendered for mapping
   * @param attributeTypeModel - the codegen model for the type of the message
   * @param attribute          - the underlying attribute that this codegen model represents.
   */
  protected AbstractAttributeCodegenModel(MapperConfig mapperConfig,
                                          MapperCodegenModelFactory factory,
                                          AbstractMapperCodegenModel attributeTypeModel,
                                          AbstractAttribute attribute) {
    super(mapperConfig, factory);
    this.attributeTypeCodegenModel = attributeTypeModel;
    this.attribute = attribute;
  }

  public String getName() {
    return attribute.getName();
  }

  public boolean isAbstractType() {
    if (attributeTypeCodegenModel != null) {
      return attributeTypeCodegenModel.getMessageNode().isAbstract();
    }
    return false;
  }

  public boolean isNeedsNullCheck() {
    return true;
  }
}