package com.github.krr.schema.generator.protobuf.mappercodegen;

@SuppressWarnings("unused")
public abstract class AbstractCodegenModel {

  protected final MapperConfig mapperConfig;

  protected final MapperCodegenModelFactory factory;

  protected AbstractCodegenModel(MapperConfig mapperConfig, MapperCodegenModelFactory factory) {
    this.mapperConfig = mapperConfig;
    this.factory = factory;
  }

  public abstract String getTemplateName();
  public abstract String getToProtoMethodName();
  public abstract String getFromProtoMethodName();
  public abstract String getProtoSetterMethod();
  public abstract String getProtoGetterMethod();
  public abstract String getBeanGetterMethod();
  public abstract String getBeanSetterMethod();

  public boolean isSuperclassAttribute() {
    throw new UnsupportedOperationException("Must be implemented by subclasses");
  }

  public boolean isAbstract() {
    throw new UnsupportedOperationException("Must be implemented by subclasses");
  }

  public String getBeanItemJavaType() {
    throw new UnsupportedOperationException("Must be implemented by subclasses.  Used for collection/map types");
  };

  public String getProtoItemJavaType() {
    throw new UnsupportedOperationException("Must be implemented by subclasses.  Used for collection/map types");
  };

  public boolean isProtoPrimitive() {
    return false;
  }

}
