package com.github.krr.schema.generator.protobuf.mappercodegen;

import com.github.krr.schema.generator.protobuf.model.nodes.messages.AbstractMessageNode;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

@SuppressWarnings("unused")
@Data
@EqualsAndHashCode(onlyExplicitlyIncluded = true)
public abstract class AbstractMapperCodegenModel {

  protected final MapperConfig mapperConfig;

  @EqualsAndHashCode.Include
  protected final AbstractMessageNode messageNode;

  protected final MapperCodegenModelFactory factory;

  protected AbstractMapperCodegenModel(MapperConfig mapperConfig,
                                       MapperCodegenModelFactory factory,
                                       AbstractMessageNode messageNode){
    this.mapperConfig = mapperConfig;
    this.factory= factory;
    this.messageNode = messageNode;
  }

  public abstract String getTemplateName();

  public abstract String getBeanJavaType();

  public abstract String getProtoJavaType();

  public String getBeanItemJavaType() {
    throw new UnsupportedOperationException("Must be implemented by subclasses");
  }

  public String getProtoItemJavaType() {
    throw new UnsupportedOperationException("Must be implemented by subclasses");
  }

  public abstract String getNewBeanInstance();

  public abstract String getNewProtoInstance();

  public abstract String getToProtoMethodName();

  public abstract String getFromProtoMethodName();

  public abstract List<AbstractCodegenModel> getAttributes();

  public boolean isHasSubclasses() {
    throw new UnsupportedOperationException("Must be implemented by subclasses");
  }

  public boolean isAbstract() {
    throw new UnsupportedOperationException("Must be implemented by subclasses");
  }


}
