package com.github.krr.schema.generator.protobuf.mappercodegen;

import com.github.krr.schema.generator.protobuf.model.nodes.attributes.AbstractAttribute;
import com.github.krr.schema.generator.protobuf.model.nodes.attributes.EnumAttribute;

public class EnumAttributeCodegenModel extends JavaAttributeCodegenModel {

  /**
   * @param mapperConfig       - the mapper configuration to use for codegen
   * @param factory            - the factory containing all message types that are rendered for mapping
   * @param attributeTypeModel - the codegen model for the type of the message
   * @param attribute          - the underlying attribute that this codegen model represents.
   */
  public EnumAttributeCodegenModel(MapperConfig mapperConfig,
                                   MapperCodegenModelFactory factory,
                                   AbstractMapperCodegenModel attributeTypeModel,
                                   AbstractAttribute attribute) {
    super(factory, mapperConfig, attributeTypeModel, attribute);
  }

  @Override
  public String getTemplateName() {
    return "mappers2/enumAttr";
  }

  @Override
  public String getToProtoMethodName() {
    return attributeTypeCodegenModel.getToProtoMethodName();
  }

  @Override
  public String getFromProtoMethodName() {
    return attributeTypeCodegenModel.getFromProtoMethodName();
  }

  @Override
  public String getBeanItemJavaType() {
    return String.format("%s.%s", attributeTypeCodegenModel.getBeanJavaType(), ((EnumAttribute)attribute).getBeanEnumValue());
  }

  @Override
  public String getProtoItemJavaType() {
    return String.format("%s.%s", attributeTypeCodegenModel.getProtoJavaType(), attribute.getName());
  }
}
