package com.github.krr.schema.generator.protobuf.mappercodegen;

import com.github.krr.schema.generator.protobuf.model.nodes.messages.EnumMessageNode;
import org.springframework.util.StringUtils;

@SuppressWarnings("unused")
public class EnumMessageCodegenModel extends PojoMapperCodegenModel {

  public EnumMessageCodegenModel(MapperConfig mapperConfig,
                                 MapperCodegenModelFactory factory,
                                 EnumMessageNode messageNode) {
    super(mapperConfig, factory, messageNode);
  }

  @Override
  public String getTemplateName() {
    return "mappers2/enumMessage";
  }

  @Override
  public String getBeanJavaType() {
    return messageNode.getBeanJavaType();
  }

  @Override
  public String getProtoJavaType() {
    return String.format("%s.%s", mapperConfig.getProtoOuterClassname(), messageNode.getProtoMessageName());
  }

  @Override
  public String getNewBeanInstance() {
    throw new UnsupportedOperationException("Enums cannot be instantiated");
  }

  @Override
  public String getNewProtoInstance() {
    throw new UnsupportedOperationException("Enums cannot be instantiated");
  }

  @Override
  public String getToProtoMethodName() {
    return String.format("%sToProto%s", StringUtils.uncapitalize(((EnumMessageNode) messageNode).getSimpleBeanName()),
                         StringUtils.capitalize(messageNode.getProtoMessageName()));
  }

  @Override
  public String getFromProtoMethodName() {
    return String.format("proto%sTo%s", StringUtils.capitalize(messageNode.getProtoMessageName()), StringUtils.capitalize(((EnumMessageNode)messageNode).getSimpleBeanName()));
  }

  public String getUnknownProtoValue() {
    return String.format("%s.%s.%s", mapperConfig.getProtoOuterClassname(), messageNode.getProtoMessageName(), ((EnumMessageNode)messageNode).getUnknownProtoValue().getName());
  }

  public String getUnknownBeanValue() {
    return String.format("%s.$UNKNOWN", messageNode.getBeanJavaType());
  }
}
