package com.github.krr.schema.generator.protobuf.mappercodegen;

import com.github.krr.schema.generator.protobuf.model.nodes.attributes.JavaAttribute;
import com.github.krr.schema.generator.protobuf.model.nodes.messages.AbstractMessageNode;
import com.github.krr.schema.generator.protobuf.utils.MapperCodegenModelUtils;
import org.springframework.util.StringUtils;

import java.util.List;
import java.util.stream.Collectors;

public class GenericMessageMapperCodegenModel extends AbstractMapperCodegenModel {

  public GenericMessageMapperCodegenModel(MapperConfig mapperConfig, MapperCodegenModelFactory factory, AbstractMessageNode messageNode) {
    super(mapperConfig, factory, messageNode);
  }

  @Override
  public String getTemplateName() {
    return "mappers2/pojoMapper";
  }

  @Override
  public String getBeanJavaType() {
    return messageNode.getBeanJavaType().replaceAll("\\$", ".");
  }

  @Override
  public String getProtoJavaType() {
    return String.format("%s.%s", mapperConfig.getProtoOuterClassname(), messageNode.getProtoMessageName());
  }

  @Override
  public String getNewBeanInstance() {
    return String.format("new %s<>()", messageNode.getBeanJavaType());
  }

  @Override
  public String getNewProtoInstance() {
    return String.format("%s.%s.newBuilder()", mapperConfig.getProtoOuterClassname(), messageNode.getProtoMessageName());
  }

  @Override
  public String getToProtoMethodName() {
    return String.format("%sToProto%s", StringUtils.uncapitalize(MapperCodegenModelUtils.getSimpleJavaBeanName(messageNode.getBeanJavaType())),
                         StringUtils.capitalize(messageNode.getProtoMessageName()));
  }

  @Override
  public String getFromProtoMethodName() {
    return String.format("proto%sTo%s", StringUtils.capitalize(messageNode.getProtoMessageName()),
                         StringUtils.capitalize(MapperCodegenModelUtils.getSimpleJavaBeanName(messageNode.getBeanJavaType())));
  }

  @Override
  public List<AbstractCodegenModel> getAttributes() {
    return messageNode.getAttributes().stream()
                      .map(a -> factory.createMapperAttributeCodegenModel(mapperConfig, (JavaAttribute) a))
                      .collect(Collectors.toList());
  }

  @Override
  public boolean isHasSubclasses() {
    return false;
  }

  @Override
  public boolean isAbstract() {
    return false;
  }
}
