package com.github.krr.schema.generator.protobuf.mappercodegen;

import com.github.krr.schema.generator.protobuf.model.nodes.attributes.AbstractAttribute;
import org.springframework.util.StringUtils;

public class JavaAttributeCodegenModel extends AbstractAttributeCodegenModel {

  public JavaAttributeCodegenModel(MapperCodegenModelFactory factory,
                                   MapperConfig mapperConfig,
                                   AbstractMapperCodegenModel attributeTypeModel,
                                   AbstractAttribute attribute) {
    super(mapperConfig, factory, attributeTypeModel, attribute);
  }

  @Override
  public String getTemplateName() {
    return "mappers2/simpleAttr";
  }

  @Override
  public String getToProtoMethodName() {
    return attributeTypeCodegenModel.getToProtoMethodName();
  }

  @Override
  public String getFromProtoMethodName() {
    return attributeTypeCodegenModel.getFromProtoMethodName();
  }

  @Override
  public String getProtoSetterMethod() {
    return String.format("set%s", StringUtils.capitalize(attribute.getName()));
  }

  @Override
  public String getProtoGetterMethod() {
    return String.format("get%s()", StringUtils.capitalize(attribute.getName()));
  }

  @Override
  public String getBeanGetterMethod() {
    return String.format("get%s()", StringUtils.capitalize(attribute.getName()));
  }

  @Override
  public String getBeanSetterMethod() {
    return String.format("set%s", StringUtils.capitalize(attribute.getName()));
  }

  @Override
  public boolean isSuperclassAttribute() {
    return attribute.isSuperclassAttribute();
  }

  @Override
  public boolean isAbstract() {
    return super.isAbstract();
  }

  @Override
  public String getBeanItemJavaType() {
    return attribute.getTypeMessageNode().getBeanItemJavaType().replaceAll("\\$", ".");
  }

  @Override
  public String getProtoItemJavaType() {
    return String.format("%s.%s", mapperConfig.getProtoOuterClassname(),
                         attribute.getTypeMessageNode().getProtoItemJavaType());
  }
}
