package com.github.krr.schema.generator.protobuf.mappercodegen;

import com.github.krr.schema.generator.protobuf.model.nodes.attributes.ProtoPrimitiveAttribute;
import com.github.krr.schema.generator.protobuf.model.nodes.messages.ObjectMessageNode;

import java.util.List;
import java.util.stream.Collectors;

public class ObjectModelMapperCodegenModel extends OneOfMapperCodegenModel {

  public ObjectModelMapperCodegenModel(MapperConfig mapperConfig,
                                       MapperCodegenModelFactory factory,
                                       ObjectMessageNode messageNode) {
    super(mapperConfig, factory, messageNode);
  }

  @Override
  public String getToProtoMethodName() {
    return "objectToProto_PrimitiveTypes";
  }

  @Override
  public String getFromProtoMethodName() {
    return "proto_PrimitiveTypesToObject";
  }

  @Override
  public String getBeanJavaType() {
    return "java.lang.Object";
  }

  @Override
  public String getProtoJavaType() {
    return String.format("%s._PrimitiveTypes", mapperConfig.getProtoOuterClassname());
  }

  @Override
  public List<AbstractCodegenModel> getAttributes() {
    return oneOfMessageNode.getAttributes().stream()
                           .map(m -> factory.createSyntheticMessageAttributeCodegenModel(mapperConfig, this, (ProtoPrimitiveAttribute) m))
                           .collect(Collectors.toList());
  }

}
