package com.github.krr.schema.generator.protobuf.mappercodegen;

import org.springframework.util.StringUtils;

@SuppressWarnings("unused")
public class OneOfAttributeCodegenModel extends AbstractCodegenModel {

  protected final AbstractMapperCodegenModel attributeTypeModel;

  protected final AbstractMapperCodegenModel subclassModel;

  public OneOfAttributeCodegenModel(MapperCodegenModelFactory factory,
                                    MapperConfig mapperConfig,
                                    AbstractMapperCodegenModel attributeTypeModel,
                                    AbstractMapperCodegenModel subclassModel) {
    super(mapperConfig, factory);
    this.attributeTypeModel = attributeTypeModel;
    this.subclassModel = subclassModel;
  }

  @Override
  public String getTemplateName() {
    throw new UnsupportedOperationException("No template for oneOf attributes");
  }

  @Override
  public String getToProtoMethodName() {
    return subclassModel.getToProtoMethodName();
  }

  @Override
  public String getFromProtoMethodName() {
    return subclassModel.getFromProtoMethodName();
  }

  @Override
  public String getProtoSetterMethod() {
    return String.format("set%s", StringUtils.capitalize(subclassModel.getMessageNode().getProtoMessageName()));
  }

  @Override
  public String getProtoGetterMethod() {
    return String.format("get%s()", StringUtils.capitalize(subclassModel.getMessageNode().getProtoMessageName()));
  }

  @Override
  public String getBeanGetterMethod() {
    throw new UnsupportedOperationException("No getBeanGetter method for oneOf attributes");
  }

  @Override
  public String getBeanSetterMethod() {
    throw new UnsupportedOperationException("No getBeanSetter method for oneOf attributes");
  }

  public String getBeanJavaType() {
    return subclassModel.getBeanJavaType();
  }

  public String getProtoJavaType() {
    return subclassModel.getProtoJavaType();
  }

  public String getProtoCheckMethod() {
    return String.format("has%s()", StringUtils.capitalize(subclassModel.getMessageNode().getProtoMessageName()));
  }
}
