package com.github.krr.schema.generator.protobuf.mappercodegen;

import com.github.krr.schema.generator.protobuf.model.nodes.messages.OneOfSyntheticMessageNode;
import com.github.krr.schema.generator.protobuf.utils.MapperCodegenModelUtils;
import org.springframework.util.StringUtils;

import java.util.List;
import java.util.stream.Collectors;

public class OneOfMapperCodegenModel extends AbstractMapperCodegenModel {

  protected final OneOfSyntheticMessageNode oneOfMessageNode;

  protected OneOfMapperCodegenModel(MapperConfig mapperConfig,
                                    MapperCodegenModelFactory factory,
                                    OneOfSyntheticMessageNode messageNode) {
    super(mapperConfig, factory, messageNode);
    this.oneOfMessageNode = messageNode;
  }

  @Override
  public String getTemplateName() {
    return "mappers2/oneof";
  }

  @Override
  public String getBeanJavaType() {
    return oneOfMessageNode.getRealMessage().getBeanJavaType();
  }

  @Override
  public String getProtoJavaType() {
    return String.format("%s.%s", mapperConfig.getProtoOuterClassname(), StringUtils.capitalize(oneOfMessageNode.getName()));
  }

  @Override
  public String getNewBeanInstance() {
    return null;
  }

  @Override
  public String getNewProtoInstance() {
    return null;
  }

  @Override
  public String getToProtoMethodName() {
    String beanMessageName = MapperCodegenModelUtils.getSimpleJavaBeanName(oneOfMessageNode.getRealMessage().getName());
    return String.format("%sToProto%s", StringUtils.uncapitalize(beanMessageName),
                         StringUtils.capitalize(oneOfMessageNode.getName()));
  }

  @Override
  public String getFromProtoMethodName() {
    String beanMessageName = MapperCodegenModelUtils.getSimpleJavaBeanName(oneOfMessageNode.getRealMessage().getName());
    return String.format("proto%sTo%s", StringUtils.capitalize(oneOfMessageNode.getName()),
                         StringUtils.capitalize(beanMessageName));
  }

  @Override
  public List<AbstractCodegenModel> getAttributes() {
    return oneOfMessageNode.getNestedNodes().stream()
                           .map(m -> factory.createSyntheticMessageAttributeCodegenModel(mapperConfig, this, m))
                           .collect(Collectors.toList());
  }
}
