package com.github.krr.schema.generator.protobuf.mappercodegen;

import com.github.krr.schema.generator.annotations.SchemaItem;
import com.github.krr.schema.generator.protobuf.model.nodes.attributes.JavaAttribute;
import com.github.krr.schema.generator.protobuf.model.nodes.messages.JavaBeanMessageNode;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.StringUtils;

import java.util.List;
import java.util.stream.Collectors;

@SuppressWarnings("unused")
public class PojoMapperCodegenModel extends AbstractMapperCodegenModel {

  private final JavaBeanMessageNode javaMessageNode;

  public PojoMapperCodegenModel(MapperConfig mapperConfig, MapperCodegenModelFactory factory, JavaBeanMessageNode messageNode) {
    super(mapperConfig, factory, messageNode);
    this.javaMessageNode = messageNode;
  }

  @Override
  public String getTemplateName() {
    return "mappers2/pojoMapper";
  }

  @Override
  public String getBeanJavaType() {
    return javaMessageNode.getBeanJavaType();
  }

  @Override
  public String getProtoJavaType() {
    return String.format("%s.%s", mapperConfig.getProtoOuterClassname(), messageNode.getProtoMessageName());
  }

  @Override
  public String getNewBeanInstance() {
    return String.format("new %s()", getBeanJavaType());
  }

  @Override
  public String getNewProtoInstance() {
    return String.format("%s.newBuilder()", getProtoJavaType());
  }

  @Override
  public String getToProtoMethodName() {
    return String.format("%sToProto%s", StringUtils.uncapitalize(getBaseclassName()),
                         StringUtils.capitalize(javaMessageNode.getProtoMessageName()));
  }

  @Override
  public String getFromProtoMethodName() {
    return String.format("proto%sTo%s", StringUtils.capitalize(javaMessageNode.getProtoMessageName()),
                         StringUtils.capitalize(getBaseclassName()));
  }

  private String getBaseclassName() {
    SchemaItem schemaItem = AnnotationUtils.findAnnotation(javaMessageNode.getBeanJavaClass(), SchemaItem.class);
    if (schemaItem != null && !StringUtils.isEmpty(schemaItem.alias())) {
      return schemaItem.alias();
    }
    return javaMessageNode.getSimpleBeanName();
  }

  @Override
  public List<AbstractCodegenModel> getAttributes() {
    return javaMessageNode.getAttributes().stream()
                          .map(a -> factory.createMapperAttributeCodegenModel(mapperConfig, (JavaAttribute) a))
                          .collect(Collectors.toList());
  }

  @Override
  public boolean isHasSubclasses() {
    return javaMessageNode.isHasSubclasses();
  }

  @Override
  public boolean isAbstract() {
    return javaMessageNode.isAbstract();
  }
}
