package com.github.krr.schema.generator.protobuf.mappercodegen;

import com.github.krr.schema.generator.protobuf.model.nodes.attributes.AbstractAttribute;
import com.github.krr.schema.generator.protobuf.model.nodes.attributes.ProtoPrimitiveAttribute;
import com.google.protobuf.ByteString;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

import java.util.HashMap;
import java.util.Map;

@SuppressWarnings("rawtypes")
public class ProtoPrimitiveAttributeCodegenModel extends JavaAttributeCodegenModel {

  public static final Map<String, Class> PROTO_PRIMITIVE_TYPE_MAP = new HashMap<>();

  static {
    PROTO_PRIMITIVE_TYPE_MAP.put("string", String.class);
    PROTO_PRIMITIVE_TYPE_MAP.put("int32", Integer.class);
    PROTO_PRIMITIVE_TYPE_MAP.put("int64", Long.class);
    PROTO_PRIMITIVE_TYPE_MAP.put("double", Double.class);
    PROTO_PRIMITIVE_TYPE_MAP.put("float", Float.class);
    PROTO_PRIMITIVE_TYPE_MAP.put("bool", Boolean.class);
    PROTO_PRIMITIVE_TYPE_MAP.put("bytes", ByteString.class);
  }

  private final ProtoPrimitiveAttribute protoPrimitiveAttr;

  public ProtoPrimitiveAttributeCodegenModel(MapperCodegenModelFactory builder, MapperConfig mapperConfig, AbstractAttribute attribute) {
    super(builder, mapperConfig, null, attribute);
    Assert.isTrue(attribute instanceof ProtoPrimitiveAttribute, "attribute must be a ProtoPrimitive type");
    this.protoPrimitiveAttr = (ProtoPrimitiveAttribute)attribute;
  }

  @Override
  public boolean isProtoPrimitive() {
    return true;
  }

  @Override
  public String getToProtoMethodName() {
    return null;
  }

  @Override
  public String getFromProtoMethodName() {
    return null;
  }


  @Override
  public String getBeanGetterMethod() {
    Class<?> beanType = (Class<?>) protoPrimitiveAttr.getBeanType();
    if(Boolean.class.isAssignableFrom(beanType) || boolean.class.isAssignableFrom(beanType)) {
      String name = protoPrimitiveAttr.getName();
      if(name.startsWith("is")) {
        return String.format("%s()", name);
      }
      return String.format("is%s()", StringUtils.capitalize(name));
    }
    return super.getBeanGetterMethod();
  }

  @Override
  public String getBeanSetterMethod() {
    Class<?> beanType = (Class<?>) protoPrimitiveAttr.getBeanType();
    if(Boolean.class.isAssignableFrom(beanType) || boolean.class.isAssignableFrom(beanType)) {
      String name = protoPrimitiveAttr.getName();
      if(name.startsWith("is")) {
        return String.format("set%s", StringUtils.capitalize(name.substring(2)));
      }
      return String.format("set%s", StringUtils.capitalize(name));
    }
    return super.getBeanSetterMethod();
  }

  @Override
  public String getBeanItemJavaType() {
    return protoPrimitiveAttr.getBeanType().getTypeName();
  }

  @Override
  public String getProtoItemJavaType() {
    return PROTO_PRIMITIVE_TYPE_MAP.get(protoPrimitiveAttr.getType()).getName().replaceAll("\\$", ".");
  }

  @Override
  public boolean isNeedsNullCheck() {
    Class beanType = (Class) protoPrimitiveAttr.getBeanType();
    return !beanType.isPrimitive();
  }
}
