package com.github.krr.schema.generator.protobuf.mappercodegen;

import com.github.krr.schema.generator.protobuf.model.nodes.attributes.JavaAttribute;
import com.github.krr.schema.generator.protobuf.model.nodes.messages.AbstractMessageNode;
import com.github.krr.schema.generator.protobuf.models.TypeInfo;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@SuppressWarnings("unused")
public class SimpleCollectionAttributeCodegenModel extends JavaAttributeCodegenModel {

  private final JavaAttribute javaAttribute;

  public SimpleCollectionAttributeCodegenModel(MapperCodegenModelFactory factory,
                                               MapperConfig mapperConfig,
                                               AbstractMapperCodegenModel messageModel,
                                               JavaAttribute attribute) {
    super(factory, mapperConfig, messageModel, attribute);
    this.javaAttribute = attribute;
  }

  @Override
  public String getTemplateName() {
    return "mappers2/collection";
  }

  @Override
  public String getToProtoMethodName() {
    TypeInfo typeInfo = javaAttribute.getTypeInfo();
    // this is a simple collection.  It gets wrapped into a wrapper object
    // because we can only determine after parsing everything whether the wrapper
    // is visible or not.  However for a simple collection, the wrapper inside this
    // wrapper collection is the one we care about, regardless of the visibility of the
    // outer wrapper.
    if(typeInfo.isPrimitiveOrStringOrObject() && typeInfo.getContainedClass() != Object.class) {
      // no conversion needed
      return null;
    }
    // find the name of this class
    AbstractMessageNode wrappedMessage = javaAttribute.getTypeMessageNode().getWrappedMessage();
    if(wrappedMessage != null) {
      // find the codegen wrapper for this wrapped message
      String key = wrappedMessage.getKey();
      AbstractMapperCodegenModel wrapperCodegenModel = factory.get(key);
      Assert.notNull(wrapperCodegenModel, "Expected to find mapper model for " + key);
      return wrapperCodegenModel.getToProtoMethodName();
    }
    return null;
  }

  @Override
  public String getFromProtoMethodName() {
    TypeInfo typeInfo = javaAttribute.getTypeInfo();
    if(typeInfo.isPrimitiveOrStringOrObject() && typeInfo.getContainedClass() != Object.class) {
      // no conversion needed
      return null;
    }
    // find the name of this class
    AbstractMessageNode wrappedMessage = javaAttribute.getTypeMessageNode().getWrappedMessage();
    if(wrappedMessage != null) {
      // find the codegen wrapper for this wrapped message
      String key = wrappedMessage.getKey();
      AbstractMapperCodegenModel wrapperCodegenModel = factory.get(key);
      Assert.notNull(wrapperCodegenModel, "Expected to find mapper model for " + key);
      return wrapperCodegenModel.getFromProtoMethodName();
    }
    return null;
  }

  @Override
  public String getProtoSetterMethod() {
    return String.format("add%s", StringUtils.capitalize(attribute.getName()));
  }

  @Override
  public String getProtoGetterMethod() {
    return String.format("get%sList()", StringUtils.capitalize(attribute.getName()));
  }

  @Override
  public String getBeanItemJavaType() {
    TypeInfo typeInfo = javaAttribute.getTypeInfo();
    // since this is a simple collection the contained class in TypeInfo is the BeanItem Type
    if(typeInfo.isGenericClass()) {
      return typeInfo.getRawType().getTypeName();
    }
    return typeInfo.getJavaType();
  }

  public String getBeanJavaType() {
    TypeInfo typeInfo = javaAttribute.getTypeInfo();
    String itemJavaType = typeInfo.getJavaType();
    String collectionType = typeInfo.getRawType().getTypeName();
    if(javaAttribute.getTypeMessageNode().getWrappedMessage() == null) {
      return String.format("%s<%s>", collectionType, itemJavaType);
    }
    return String.format("%s<%s>", collectionType, javaAttribute.getBeanItemJavaType());
  }

  public String getBeanNewInstance() {
    TypeInfo typeInfo = javaAttribute.getTypeInfo();
    return typeInfo.getCollectionNewInstance();
  }

  @Override
  public String getProtoItemJavaType() {
    AbstractMessageNode typeMessageNode = javaAttribute.getTypeMessageNode();
    AbstractMessageNode wrappedMessage = typeMessageNode.getWrappedMessage();
    if(wrappedMessage == null ||  wrappedMessage.isPrimitiveType()) {
      return javaAttribute.getTypeInfo().getContainedClass().getName();
    }
    return String.format("%s.%s", mapperConfig.getProtoOuterClassname(), javaAttribute.getProtoItemJavaType());
  }
}
