package com.github.krr.schema.generator.protobuf.mappercodegen;

import com.github.krr.schema.generator.protobuf.model.nodes.attributes.JavaAttribute;
import org.springframework.util.StringUtils;

public class SimpleMapAttributeCodegenModel extends SimpleCollectionAttributeCodegenModel {

  public SimpleMapAttributeCodegenModel(MapperCodegenModelFactory builder, MapperConfig mapperConfig, AbstractMapperCodegenModel messageModel, JavaAttribute attribute) {
    super(builder, mapperConfig, messageModel, attribute);
  }

  @Override
  public String getTemplateName() {
    return "mappers2/map";
  }

  @Override
  public String getProtoSetterMethod() {
    return String.format("put%s", StringUtils.capitalize(attribute.getName()));
  }

  @Override
  public String getProtoGetterMethod() {
    return String.format("get%sMap()", StringUtils.capitalize(attribute.getName()));
  }


}
