package com.github.krr.schema.generator.protobuf.mappercodegen;

import com.github.krr.schema.generator.protobuf.model.nodes.attributes.ProtoPrimitiveAttribute;
import org.springframework.util.StringUtils;

public class SyntheticProtoPrimitiveAttributeCodegenModel extends OneOfAttributeCodegenModel {

  private final ProtoPrimitiveAttribute attribute;

  public SyntheticProtoPrimitiveAttributeCodegenModel(MapperCodegenModelFactory factory,
                                                      MapperConfig mapperConfig,
                                                      AbstractMapperCodegenModel attributeTypeModel,
                                                      ProtoPrimitiveAttribute attribute) {
    super(factory, mapperConfig, attributeTypeModel, null);
    this.attribute = attribute;
  }

  @Override
  public String getToProtoMethodName() {
    if(attribute.getBeanType() == byte[].class) {
      return "ByteString.copyFrom";
    }
    return null;
  }

  @Override
  public String getFromProtoMethodName() {
    return null;
  }

  @Override
  public String getBeanJavaType() {
    return attribute.getBeanType().getTypeName();
  }

  @Override
  public String getProtoSetterMethod() {
    return String.format("set%s", StringUtils.capitalize(attribute.getName()));
  }

  @Override
  public String getProtoGetterMethod() {
    String getterMethod = String.format("get%s()", StringUtils.capitalize(attribute.getName()));
    if(attribute.getBeanType() == byte[].class) {
      return getterMethod.concat(".toByteArray()");
    }
    return getterMethod;
  }

  @Override
  public String getBeanGetterMethod() {
    throw new UnsupportedOperationException("No getBeanGetter method for oneOf attributes");
  }

  @Override
  public String getBeanSetterMethod() {
    throw new UnsupportedOperationException("No getBeanSetter method for oneOf attributes");
  }

  public String getProtoCheckMethod() {
    return String.format("has%s()", StringUtils.capitalize(attribute.getName()));
  }

}
