package com.github.krr.schema.generator.protobuf.model.builders;

import com.github.krr.schema.generator.protobuf.impl.ProtobufSchemaGenerator;
import com.github.krr.schema.generator.protobuf.model.MessageNodeBuilder;
import com.github.krr.schema.generator.protobuf.model.nodes.TypeNode;
import com.github.krr.schema.generator.protobuf.model.nodes.attributes.ProtoPrimitiveAttribute;
import com.github.krr.schema.generator.protobuf.model.nodes.attributes.SuperclassAttribute;
import com.github.krr.schema.generator.protobuf.model.nodes.messages.AbstractMessageNode;
import com.github.krr.schema.generator.protobuf.model.nodes.messages.AbstractSyntheticMessageNode;
import lombok.SneakyThrows;
import org.springframework.util.Assert;

import java.lang.reflect.Type;

@SuppressWarnings("rawtypes")
public abstract class AbstractParameterizedSubclassMessageNodeBuilder extends PojoMessageModelNodeBuilder {

  @SneakyThrows
  @Override
  public AbstractMessageNode buildNode(MessageNodeBuilder builder, TypeNode typeNode, ProtobufSchemaGenerator.ProtoSyntax syntax) {
    Class clazz = (Class) typeNode.getType();
    Type valueType = getTypeParameter(clazz.getGenericSuperclass());
    String valueKey = valueType.getTypeName();
    String valueProtoMessage;
    AbstractMessageNode valueNode = null;
    if (!isProtoPrimitive(valueType) || valueType == Object.class) {
      valueNode = builder.findNode(valueKey);
      if (valueNode == null) {
        valueNode = builder.build(new TypeNode(valueKey, valueType), syntax);
        Assert.notNull(valueNode, "Could not create model for value node:" + valueKey);
      }
      valueProtoMessage = valueNode.getProtoMessageName();
    }
    else {
      valueProtoMessage = ProtoPrimitiveAttribute.PROTO_PRIMITIVE_TYPE_MAP.get((Class) valueType);
    }
    AbstractMessageNode msgNode = super.buildNode(builder, typeNode, syntax);
    Assert.notNull(msgNode, "Expecting a non null message node");
    // register this msg node with the valueNode
    if (valueNode instanceof AbstractSyntheticMessageNode) {
      ((AbstractSyntheticMessageNode)valueNode).getReferencedNodes().add(msgNode);
    }
    // compose with an attribute for the map itself.
    SuperclassAttribute composedAttribute = getComposedAttribute(typeNode, clazz, valueProtoMessage);
    composedAttribute.setContainingMessageNode(msgNode);
    msgNode.addAttribute(composedAttribute);
    return msgNode;
  }

  protected abstract SuperclassAttribute getComposedAttribute(TypeNode typeNode, Class clazz, String valueProtoMessage);

  protected abstract Type getTypeParameter(Type superclassType);

}
