package com.github.krr.schema.generator.protobuf.model.builders;

import com.github.krr.schema.generator.protobuf.impl.ProtobufSchemaGenerator;
import com.github.krr.schema.generator.protobuf.model.MessageNodeBuilder;
import com.github.krr.schema.generator.protobuf.model.nodes.TypeNode;
import com.github.krr.schema.generator.protobuf.model.nodes.attributes.EnumAttribute;
import com.github.krr.schema.generator.protobuf.model.nodes.messages.AbstractMessageNode;
import com.github.krr.schema.generator.protobuf.model.nodes.messages.EnumMessageNode;

import java.lang.reflect.Type;

import static com.github.krr.schema.generator.protobuf.utils.MapperCodegenModelUtils.getBaseClassName;

@SuppressWarnings({"rawtypes", "unchecked"})
public class EnumMessageModelNodeBuilder extends AbstractMessageModelNodeBuilder {

  @Override
  public AbstractMessageNode buildNode(MessageNodeBuilder messageNodeBuilder, TypeNode typeNode, ProtobufSchemaGenerator.ProtoSyntax syntax) {
    Class clazz = (Class)typeNode.getType();
    String key = clazz.getName();
    AbstractMessageNode node = messageNodeBuilder.findNode(key);
    if(node != null) {
      return node;
    }
    EnumMessageNode messageModel = new EnumMessageNode(key, clazz);
    messageModel.setProtoMessageName(getProtoCompatibleName(key));
    Object[] enumConstants = clazz.getEnumConstants();
    // add an _UNKNOWN value with index 0 for backward compatibility
    boolean foundUnknown = false;
    for (Object enumConstant : enumConstants) {
      EnumAttribute attrModel;
      // skip $UNKNOWN - note this MUST exist because the proto has it.
      String enumName = enumConstant.toString();
      if (!"$UNKNOWN".equals(enumName)) {
        // protoType must be blank since the name of each enum is the type.
        attrModel = new EnumAttribute(enumName, "", clazz, getIndexForEnum((Class<? extends Enum>) clazz, (Enum) enumConstant));
        attrModel.setBeanEnumValue(((Enum<?>) enumConstant).name());
        messageModel.addAttribute(attrModel);
      }
      else {
        attrModel = new EnumAttribute(getBaseClassName(clazz).toUpperCase().concat("_UNKNOWN"), "", clazz, 0);
        attrModel.setBeanEnumValue(((Enum<?>) enumConstant).name());
        messageModel.setUnknownProtoValue(attrModel);
        foundUnknown = true;
        // $UNKNOWN must always be at index 0 in proto3.
        messageModel.getAttributes().add(0, attrModel);
      }
      attrModel.setContainingMessageNode(messageModel);
      // all enums attributes are types of the same message
      attrModel.setTypeMessageNode(messageModel);
    }
    if (!foundUnknown) {
      throw new UnsupportedOperationException("Enum " + clazz.getName() + " does not define a $UNKNOWN value");
    }
    messageNodeBuilder.registerMessage(key, messageModel);
    return messageModel;
  }

  @Override
  public boolean supports(TypeNode typeNode) {
    Type type = typeNode.getType();
    return type instanceof Class && ((Class<?>) type).isEnum();
  }
}
