package com.github.krr.schema.generator.protobuf.model.builders;

import com.github.krr.schema.generator.protobuf.impl.ProtobufSchemaGenerator.ProtoSyntax;
import com.github.krr.schema.generator.protobuf.model.MessageNodeBuilder;
import com.github.krr.schema.generator.protobuf.model.nodes.TypeNode;
import com.github.krr.schema.generator.protobuf.model.nodes.messages.AbstractMessageNode;
import com.github.krr.schema.generator.protobuf.model.nodes.messages.AbstractSyntheticMessageNode;
import lombok.extern.slf4j.Slf4j;

import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;

@SuppressWarnings("rawtypes")
@Slf4j
public class GenericMessageModelNodeBuilder extends PojoWithSubclassesMessageModelNodeBuilder {

  @Override
  public AbstractMessageNode buildNode(MessageNodeBuilder builder, TypeNode typeNode, ProtoSyntax syntax) {
    Class clazz = (Class) typeNode.getType();
    String key = AbstractSyntheticMessageNode.getKey(clazz);
    AbstractMessageNode node = builder.findNode(key);
    if(node != null) {
      return node;
    }
    Type[] typeParameters = clazz.getTypeParameters();
    AbstractMessageNode[] boundNodes = null;
    for (Type typeArgument : typeParameters) {
      // this node is a child of the collection node.
      TypeVariable typeVariable = (TypeVariable)typeArgument;
      Type[] bounds = typeVariable.getBounds();
      int index = 0;
      boundNodes  = new AbstractMessageNode[bounds.length];
      for(Type bound : bounds) {
        // the bounds get registered
        boundNodes[index] = builder.build(new TypeNode(AbstractSyntheticMessageNode.getKey(typeVariable), bound), syntax);
        log.debug("Created model for bound: {}", boundNodes[index++]);
      }
    }
    AbstractMessageNode retval = super.buildNode(builder, typeNode, syntax);
    // the bound Nodes each are referenced by this generic class.  Make sure we reference count it
    // so they will be rendered correctly.
    if(boundNodes != null && boundNodes.length > 0) {
      for (AbstractMessageNode boundNode : boundNodes) {
        if(boundNode instanceof AbstractSyntheticMessageNode) {
          ((AbstractSyntheticMessageNode) boundNode).getReferencedNodes().add(retval);
        }
      }
    }
    return retval;
  }

  @Override
  public boolean supports(TypeNode typeNode) {
    Type type = typeNode.getType();
    // non-generic class
    return Class.class.isAssignableFrom(type.getClass()) &&
           ((Class)type).getTypeParameters().length > 0
        ;
  }
}
