package com.github.krr.schema.generator.protobuf.model.builders;

import com.github.krr.schema.generator.protobuf.impl.ProtobufSchemaGenerator;
import com.github.krr.schema.generator.protobuf.model.MessageNodeBuilder;
import com.github.krr.schema.generator.protobuf.model.nodes.TypeNode;
import com.github.krr.schema.generator.protobuf.model.nodes.attributes.AbstractAttribute;
import com.github.krr.schema.generator.protobuf.model.nodes.messages.AbstractMessageNode;
import com.github.krr.schema.generator.protobuf.model.nodes.messages.AbstractSyntheticMessageNode;
import com.github.krr.schema.generator.protobuf.model.nodes.messages.GenericMessageNode;
import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;
import org.springframework.util.Assert;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;

@SuppressWarnings("rawtypes")
@Slf4j
public class GenericParameterizedTypeMessageNodeBuilder extends PojoMessageModelNodeBuilder {

  @SneakyThrows
  @Override
  public AbstractMessageNode buildNode(MessageNodeBuilder messageNodeBuilder, TypeNode typeNode, ProtobufSchemaGenerator.ProtoSyntax syntax) {

    ParameterizedType type = (ParameterizedType) typeNode.getType();
    String thisMessageTypeKey = AbstractSyntheticMessageNode.getKey(type);
    AbstractMessageNode node = messageNodeBuilder.findNode(thisMessageTypeKey);
    if (node != null) {
      return node;
    }
    node = new GenericMessageNode(thisMessageTypeKey, (Class)type.getRawType());
    messageNodeBuilder.start(thisMessageTypeKey, node);
    node.setProtoMessageName(getProtoCompatibleName(thisMessageTypeKey));
    // this is a parameterized type (map/list/generic).  get the inner type
    // that this message node will wrap
    Type[] genericTypes = type.getActualTypeArguments();
    long index = 10;
    AbstractAttribute attr;
    for (Type genericType : genericTypes) {
      // check each type in the generic type.  Ensure that their message models exist/create if they don't
      String name = String.format("_param%d", index);
      String genericTypeKey = AbstractSyntheticMessageNode.getKey(genericType);
      log.debug("Looking up message for {}", genericTypeKey);
      AbstractMessageNode genericTypeMessageNode = messageNodeBuilder.findNode(genericTypeKey);
      if (genericTypeMessageNode == null) {
        genericTypeMessageNode = messageNodeBuilder.build(new TypeNode(genericTypeKey, genericType), syntax);
        Assert.notNull(genericTypeMessageNode, "Could not create message node for " + genericType);
      }
    }
    // add pojo attributes of this class.
    postProcessMessageNode(messageNodeBuilder, thisMessageTypeKey, syntax, (Class) type.getRawType(), node);
    return node;
  }

  @Override
  public boolean supports(TypeNode typeNode) {
    Type type = typeNode.getType();
    return type instanceof ParameterizedType &&
           !Collection.class.isAssignableFrom((Class) ((ParameterizedType) type).getRawType()) &&
           !Map.class.isAssignableFrom((Class) ((ParameterizedType) type).getRawType())
        ;
  }

  @Override
  public String getKey(Type type) {
    return ((ParameterizedType)type).getRawType().getTypeName();
  }
}
