package com.github.krr.schema.generator.protobuf.model.builders;

import com.github.krr.schema.generator.protobuf.model.nodes.TypeNode;
import com.github.krr.schema.generator.protobuf.model.nodes.attributes.SyntheticAttribute;
import com.github.krr.schema.generator.protobuf.model.nodes.messages.AbstractMessageNode;
import com.github.krr.schema.generator.protobuf.model.nodes.messages.AbstractSyntheticMessageNode;
import com.github.krr.schema.generator.protobuf.model.nodes.messages.MapMessageNode;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;

@SuppressWarnings("rawtypes")
public class MapParameterizedMessageNodeBuilder extends CollectionParameterizedMessageNodeBuilder {

  public static final String KVPAIRS = "_kvpairs";

  @Override
  protected Type getActualTypeArgument(ParameterizedType type) {
    return type.getActualTypeArguments()[1];
  }

  @Override
  public boolean supports(TypeNode typeNode) {
    Type type = typeNode.getType();
    return typeNode.getType() instanceof ParameterizedType && Map.class.isAssignableFrom((Class)((ParameterizedType)type).getRawType());
  }

  protected AbstractSyntheticMessageNode getMessageNodeInstance(TypeNode typeNode, AbstractMessageNode valueMessageNode, ParameterizedType type) {
    MapMessageNode mapMessageNode = new MapMessageNode(type, typeNode.getName());
    SyntheticAttribute attribute = new SyntheticAttribute(KVPAIRS, getItemType(valueMessageNode), 10);
    updateOneOfNode(typeNode, valueMessageNode, mapMessageNode, attribute);
    attribute.setMapAttr(true);
    attribute.setContainingMessageNode(mapMessageNode);
    mapMessageNode.addAttribute(attribute);

    return mapMessageNode;
  }

  protected String getItemType(AbstractMessageNode messageNode) {
//    Type actualTypeArgument = ((ParameterizedType) messageNode.getType()).getActualTypeArguments()[1];
    return String.format("map<string, %s>", messageNode.getProtoMessageName());
  }
}
