package com.github.krr.schema.generator.protobuf.model.builders;

import com.github.krr.schema.generator.protobuf.model.nodes.TypeNode;
import com.github.krr.schema.generator.protobuf.model.nodes.attributes.SuperclassAttribute;
import lombok.SneakyThrows;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.Map;

@SuppressWarnings("rawtypes")
public class MapSubclassMessageNodeBuilder extends AbstractParameterizedSubclassMessageNodeBuilder {

  @Override
  protected Type getTypeParameter(Type superclassType) {
    if(superclassType instanceof ParameterizedType) {
      return ((ParameterizedType) superclassType).getActualTypeArguments()[1];
    }
    else if(superclassType instanceof Class) {
      return ((Class<?>) superclassType).getTypeParameters()[0].getBounds()[1];
    }
    else if(superclassType instanceof WildcardType) {
      return ((WildcardType) superclassType).getUpperBounds()[0];
    }
    throw new UnsupportedOperationException("Unsupported type " + superclassType);
  }

  @SneakyThrows
  protected SuperclassAttribute getComposedAttribute(TypeNode typeNode, Class clazz, String valueProtoMessage) {
    return new SuperclassAttribute("_kvPairs",
                                   String.format("map<string, %s>", valueProtoMessage),
                                   Class.forName(clazz.getTypeName()),
                                   getIndex((AnnotatedElement) typeNode.getType()));
  }

  @Override
  public boolean supports(TypeNode typeNode) {
    Type type = typeNode.getType();
    return type instanceof Class && Map.class.isAssignableFrom((Class) type);
  }

}
