package com.github.krr.schema.generator.protobuf.model.builders;

import com.github.krr.schema.generator.protobuf.impl.ProtobufSchemaGenerator;
import com.github.krr.schema.generator.protobuf.model.MessageNodeBuilder;
import com.github.krr.schema.generator.protobuf.model.nodes.*;
import com.github.krr.schema.generator.protobuf.model.nodes.attributes.AbstractAttribute;
import com.github.krr.schema.generator.protobuf.model.nodes.attributes.ProtoPrimitiveAttribute;
import com.github.krr.schema.generator.protobuf.model.nodes.messages.AbstractMessageNode;
import com.github.krr.schema.generator.protobuf.model.nodes.messages.ObjectMessageNode;

import java.lang.reflect.Type;
import java.util.List;

@SuppressWarnings({"RedundantCast", "rawtypes"})
public class ObjectMessageNodeBuilder extends AbstractMessageModelNodeBuilder {

  public static final String PROTO_MESSAGE_TYPE = "_PrimitiveTypes";

  private long index = 100;

  private final List<AbstractAttribute> OBJECT_ATTRIBUTES = List.of(new ProtoPrimitiveAttribute("stringValue", String.class, index++),
                                                                    new ProtoPrimitiveAttribute("longValue", Long.class, index++),
                                                                    new ProtoPrimitiveAttribute("doubleValue", Double.class, index++),
                                                                    new ProtoPrimitiveAttribute("intValue", Integer.class, index++),
                                                                    new ProtoPrimitiveAttribute("boolValue", Boolean.class, index++),
                                                                    new ProtoPrimitiveAttribute("byteValue", byte[].class, index++),
                                                                    new ProtoPrimitiveAttribute("floatValue", Float.class, index++)
                                                                   );

  @Override
  public AbstractMessageNode buildNode(MessageNodeBuilder messageNodeBuilder, TypeNode type, ProtobufSchemaGenerator.ProtoSyntax syntax) {
    AbstractMessageNode messageNode = new ObjectMessageNode(PROTO_MESSAGE_TYPE);
    messageNode.addAttributes(OBJECT_ATTRIBUTES);
    OBJECT_ATTRIBUTES.forEach(a -> a.setContainingMessageNode(messageNode));
    messageNode.setProtoMessageName(PROTO_MESSAGE_TYPE);
    messageNodeBuilder.registerMessage(PROTO_MESSAGE_TYPE, messageNode);
    return messageNode;
  }

  @Override
  public boolean supports(TypeNode typeNode) {
    Type type = typeNode.getType();
    return type instanceof Class && ((Class) type) == Object.class;
  }
}
