package com.github.krr.schema.generator.protobuf.model.builders;

import com.github.krr.schema.generator.protobuf.impl.ProtobufSchemaGenerator.ProtoSyntax;
import com.github.krr.schema.generator.protobuf.model.MessageNodeBuilder;
import com.github.krr.schema.generator.protobuf.model.nodes.TypeNode;
import com.github.krr.schema.generator.protobuf.model.nodes.messages.AbstractMessageNode;
import com.github.krr.schema.generator.protobuf.model.nodes.messages.JavaBeanMessageNode;
import lombok.extern.slf4j.Slf4j;

import java.lang.reflect.Type;

import static com.github.krr.schema.generator.protobuf.model.builders.PojoWithSubclassesMessageModelNodeBuilder.getSubTypesForClass;

@SuppressWarnings({"rawtypes", "UnstableApiUsage"})
@Slf4j
public class PojoMessageModelNodeBuilder extends AbstractMessageModelNodeBuilder {

  @Override
  public AbstractMessageNode buildNode(MessageNodeBuilder builder, TypeNode typeNode, ProtoSyntax syntax) {
    // For pojo - build
    Class clazz = (Class) typeNode.getType();
    String key = clazz.getName();
    AbstractMessageNode node = builder.findNode(key);
    if (node != null) {
      return node;
    }
    node = new JavaBeanMessageNode(key, clazz);
    builder.start(key, node);
    node.setProtoMessageName(getProtoCompatibleName(clazz.getName()));
    postProcessMessageNode(builder, key, syntax, clazz, node);
    return node;
  }

  protected void postProcessMessageNode(MessageNodeBuilder builder,
                                        String key,
                                        ProtoSyntax syntax,
                                        Class clazz,
                                        AbstractMessageNode node) {
    addPojoAttributes(builder, syntax, clazz, node);
    addSuperclassAttribute(builder, syntax, clazz, node);
    builder.registerMessage(node.getKey(), node);
    builder.finish(key);
  }

  @Override
  public boolean supports(TypeNode typeNode) {
    Type type = typeNode.getType();
    // non-generic class
    if (!(type instanceof Class)) {
      return false;
    }// not generic
    // not a proto primitive type
    // does not have subclasses
    Class clazz = (Class) type;
    return clazz.getTypeParameters().length == 0 &&
           // not a proto primitive type
           !isProtoPrimitive(type) &&
           // does not have subclasses
           getSubTypesForClass(clazz).nodes().size() == 0;
  }

}
